/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.util;

public class IntList {
    private int[] entries;
    private int count;

    public IntList() {
        this(10);
    }

    public IntList(int capacity) {
        this.entries = new int[capacity];
    }

    public int size() {
        return this.count;
    }

    public int get(int i) {
        if (this.count <= i) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.entries[i];
    }

    public void clear() {
        this.count = 0;
    }

    public void add(int n) {
        if (this.count == this.entries.length) {
            this.grow();
        }
        this.entries[this.count++] = n;
    }

    public void fillTo(int toIndex, int val) {
        while (this.count < toIndex) {
            this.add(val);
        }
    }

    private void grow() {
        int[] n = new int[(this.entries.length + 16) * 3 / 2];
        System.arraycopy(this.entries, 0, n, 0, this.count);
        this.entries = n;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append('[');
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                r.append(", ");
            }
            r.append(this.entries[i]);
        }
        r.append(']');
        return r.toString();
    }
}

