/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class NB {
    public static void readFully(InputStream fd, byte[] dst, int off, int len) throws IOException {
        while (len > 0) {
            int r = fd.read(dst, off, len);
            if (r <= 0) {
                throw new EOFException("Short read of block.");
            }
            off += r;
            len -= r;
        }
    }

    public static void skipFully(InputStream fd, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException("Short skip of block");
            }
            toSkip -= r;
        }
    }

    public static int compareUInt32(int a, int b) {
        int cmp = (a >>> 1) - (b >>> 1);
        if (cmp != 0) {
            return cmp;
        }
        return (a & 1) - (b & 1);
    }

    public static int decodeUInt16(byte[] intbuf, int offset) {
        int r = (intbuf[offset] & 0xFF) << 8;
        return r | intbuf[offset + 1] & 0xFF;
    }

    public static int decodeInt32(byte[] intbuf, int offset) {
        int r = intbuf[offset] << 8;
        r |= intbuf[offset + 1] & 0xFF;
        r <<= 8;
        return (r |= intbuf[offset + 2] & 0xFF) << 8 | intbuf[offset + 3] & 0xFF;
    }

    public static long decodeUInt32(byte[] intbuf, int offset) {
        int low = (intbuf[offset + 1] & 0xFF) << 8;
        low |= intbuf[offset + 2] & 0xFF;
        low <<= 8;
        return (long)(intbuf[offset] & 0xFF) << 24 | (long)(low |= intbuf[offset + 3] & 0xFF);
    }

    public static long decodeUInt64(byte[] intbuf, int offset) {
        return NB.decodeUInt32(intbuf, offset) << 32 | NB.decodeUInt32(intbuf, offset + 4);
    }

    public static void encodeInt16(byte[] intbuf, int offset, int v) {
        intbuf[offset + 1] = (byte)v;
        intbuf[offset] = (byte)(v >>>= 8);
    }

    public static void encodeInt32(byte[] intbuf, int offset, int v) {
        intbuf[offset + 3] = (byte)v;
        intbuf[offset + 2] = (byte)(v >>>= 8);
        intbuf[offset + 1] = (byte)(v >>>= 8);
        intbuf[offset] = (byte)(v >>>= 8);
    }

    public static void encodeInt64(byte[] intbuf, int offset, long v) {
        intbuf[offset + 7] = (byte)v;
        intbuf[offset + 6] = (byte)(v >>>= 8);
        intbuf[offset + 5] = (byte)(v >>>= 8);
        intbuf[offset + 4] = (byte)(v >>>= 8);
        intbuf[offset + 3] = (byte)(v >>>= 8);
        intbuf[offset + 2] = (byte)(v >>>= 8);
        intbuf[offset + 1] = (byte)(v >>>= 8);
        intbuf[offset] = (byte)(v >>>= 8);
    }

    private NB() {
    }
}

