/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import org.spearce.jgit.lib.Constants;
import org.spearce.jgit.lib.ObjectChecker;
import org.spearce.jgit.lib.PersonIdent;
import org.spearce.jgit.util.IntList;
import org.spearce.jgit.util.MutableInteger;

public final class RawParseUtils {
    private static final byte[] digits = new byte[58];
    private static final byte[] base10byte;

    public static final int match(byte[] b, int ptr, byte[] src) {
        if (ptr + src.length > b.length) {
            return -1;
        }
        int i = 0;
        while (i < src.length) {
            if (b[ptr] != src[i]) {
                return -1;
            }
            ++i;
            ++ptr;
        }
        return ptr;
    }

    public static int formatBase10(byte[] b, int o, int value) {
        boolean isneg;
        if (value == 0) {
            b[--o] = 48;
            return o;
        }
        boolean bl = isneg = value < 0;
        while (value != 0) {
            b[--o] = base10byte[value % 10];
            value /= 10;
        }
        if (isneg) {
            b[--o] = 45;
        }
        return o;
    }

    public static final int parseBase10(byte[] b, int ptr, MutableInteger ptrResult) {
        int r = 0;
        int sign = 0;
        try {
            byte v;
            int sz = b.length;
            while (ptr < sz && b[ptr] == 32) {
                ++ptr;
            }
            if (ptr >= sz) {
                return 0;
            }
            switch (b[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                }
            }
            while (ptr < sz && (v = digits[b[ptr]]) >= 0) {
                r = r * 10 + v;
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (ptrResult != null) {
            ptrResult.value = ptr;
        }
        return sign < 0 ? -r : r;
    }

    public static final long parseLongBase10(byte[] b, int ptr, MutableInteger ptrResult) {
        long r = 0L;
        int sign = 0;
        try {
            byte v;
            int sz = b.length;
            while (ptr < sz && b[ptr] == 32) {
                ++ptr;
            }
            if (ptr >= sz) {
                return 0L;
            }
            switch (b[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                }
            }
            while (ptr < sz && (v = digits[b[ptr]]) >= 0) {
                r = r * 10L + (long)v;
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (ptrResult != null) {
            ptrResult.value = ptr;
        }
        return sign < 0 ? -r : r;
    }

    public static final int parseTimeZoneOffset(byte[] b, int ptr) {
        int v = RawParseUtils.parseBase10(b, ptr, null);
        int tzMins = v % 100;
        int tzHours = v / 100;
        return tzHours * 60 + tzMins;
    }

    public static final int next(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            if (b[ptr++] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int nextLF(byte[] b, int ptr) {
        return RawParseUtils.next(b, ptr, '\n');
    }

    public static final int nextLF(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            byte c;
            if ((c = b[ptr++]) != chrA && c != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final IntList lineMap(byte[] buf, int ptr, int end) {
        IntList map = new IntList((end - ptr) / 36);
        map.fillTo(1, Integer.MIN_VALUE);
        while (ptr < end) {
            map.add(ptr);
            ptr = RawParseUtils.nextLF(buf, ptr);
        }
        return map;
    }

    public static final int author(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.match(b, ptr, ObjectChecker.author);
    }

    public static final int committer(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        if (ptr < sz && b[ptr] == 97) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return RawParseUtils.match(b, ptr, ObjectChecker.committer);
    }

    public static final int tagger(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz) {
            if (b[ptr] == 10) {
                return -1;
            }
            int m = RawParseUtils.match(b, ptr, ObjectChecker.tagger);
            if (m >= 0) {
                return m;
            }
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return -1;
    }

    public static final int encoding(byte[] b, int ptr) {
        int sz = b.length;
        while (ptr < sz) {
            if (b[ptr] == 10) {
                return -1;
            }
            if (b[ptr] == 101) break;
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return RawParseUtils.match(b, ptr, ObjectChecker.encoding);
    }

    public static Charset parseEncoding(byte[] b) {
        int enc = RawParseUtils.encoding(b, 0);
        if (enc < 0) {
            return Constants.CHARSET;
        }
        int lf = RawParseUtils.nextLF(b, enc);
        return Charset.forName(RawParseUtils.decode(Constants.CHARSET, b, enc, lf - 1));
    }

    public static PersonIdent parsePersonIdent(byte[] raw, int nameB) {
        Charset cs = RawParseUtils.parseEncoding(raw);
        int emailB = RawParseUtils.nextLF(raw, nameB, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        String name = RawParseUtils.decode(cs, raw, nameB, emailB - 2);
        String email = RawParseUtils.decode(cs, raw, emailB, emailE - 1);
        MutableInteger ptrout = new MutableInteger();
        long when = RawParseUtils.parseLongBase10(raw, emailE + 1, ptrout);
        int tz = RawParseUtils.parseTimeZoneOffset(raw, ptrout.value);
        return new PersonIdent(name, email, when * 1000L, tz);
    }

    public static String decode(byte[] buffer) {
        return RawParseUtils.decode(Constants.CHARSET, buffer, 0, buffer.length);
    }

    public static String decode(Charset cs, byte[] buffer) {
        return RawParseUtils.decode(cs, buffer, 0, buffer.length);
    }

    public static String decode(Charset cs, byte[] buffer, int start, int end) {
        try {
            return RawParseUtils.decodeNoFallback(cs, buffer, start, end);
        }
        catch (CharacterCodingException e) {
            return RawParseUtils.extractBinaryString(buffer, start, end);
        }
    }

    public static String decodeNoFallback(Charset cs, byte[] buffer, int start, int end) throws CharacterCodingException {
        ByteBuffer b = ByteBuffer.wrap(buffer, start, end - start);
        b.mark();
        try {
            return RawParseUtils.decode(b, Constants.CHARSET);
        }
        catch (CharacterCodingException e) {
            Charset defcs;
            b.reset();
            if (!cs.equals(Constants.CHARSET)) {
                try {
                    return RawParseUtils.decode(b, cs);
                }
                catch (CharacterCodingException e2) {
                    b.reset();
                }
            }
            if (!(defcs = Charset.defaultCharset()).equals(cs) && !defcs.equals(Constants.CHARSET)) {
                try {
                    return RawParseUtils.decode(b, defcs);
                }
                catch (CharacterCodingException e3) {
                    b.reset();
                }
            }
            throw new CharacterCodingException();
        }
    }

    public static String extractBinaryString(byte[] buffer, int start, int end) {
        StringBuilder r = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            r.append((char)(buffer[i] & 0xFF));
        }
        return r.toString();
    }

    private static String decode(ByteBuffer b, Charset charset) throws CharacterCodingException {
        CharsetDecoder d = charset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPORT);
        d.onUnmappableCharacter(CodingErrorAction.REPORT);
        return d.decode(b).toString();
    }

    public static final int commitMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.tagMessage(b, ptr);
    }

    public static final int tagMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz && b[ptr] != 10) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        if (ptr < sz && b[ptr] == 10) {
            return ptr + 1;
        }
        return -1;
    }

    public static final int endOfParagraph(byte[] b, int start) {
        int ptr = start;
        int sz = b.length;
        while (ptr < sz && b[ptr] != 10) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        while (0 < ptr && start < ptr && b[ptr - 1] == 10) {
            --ptr;
        }
        return ptr;
    }

    private RawParseUtils() {
    }

    static {
        Arrays.fill(digits, (byte)-1);
        for (int i = 48; i <= 57; i = (int)((char)(i + 1))) {
            RawParseUtils.digits[i] = (byte)(i - 48);
        }
        base10byte = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }
}

