/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.util;

import java.io.UnsupportedEncodingException;
import org.spearce.jgit.util.RawCharSequence;

public class RawSubStringPattern {
    private final String needleString;
    private final byte[] needle;

    public RawSubStringPattern(String patternText) {
        byte[] b;
        if (patternText.length() == 0) {
            throw new IllegalArgumentException("Cannot match on empty string.");
        }
        this.needleString = patternText;
        try {
            b = patternText.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM lacks UTF-8 support.", e);
        }
        this.needle = new byte[b.length];
        for (int i = 0; i < b.length; ++i) {
            this.needle[i] = RawSubStringPattern.lc(b[i]);
        }
    }

    public int match(RawCharSequence rcs) {
        int needleLen = this.needle.length;
        byte first = this.needle[0];
        byte[] text = rcs.buffer;
        int maxPos = rcs.endPtr - needleLen;
        block0: for (int matchPos = rcs.startPtr; matchPos < maxPos; ++matchPos) {
            if (RawSubStringPattern.neq(first, text[matchPos])) {
                while (++matchPos < maxPos && RawSubStringPattern.neq(first, text[matchPos])) {
                }
                if (matchPos == maxPos) {
                    return -1;
                }
            }
            int si = ++matchPos;
            int j = 1;
            while (j < needleLen) {
                if (RawSubStringPattern.neq(this.needle[j], text[si])) continue block0;
                ++j;
                ++si;
            }
            return matchPos - 1;
        }
        return -1;
    }

    private static final boolean neq(byte a, byte b) {
        return a != b && a != RawSubStringPattern.lc(b);
    }

    private static final byte lc(byte q) {
        return (byte)Character.toLowerCase((char)(q & 0xFF));
    }

    public String pattern() {
        return this.needleString;
    }

    public String toString() {
        return this.pattern();
    }
}

