/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.api;

import java.io.File;
import java.io.IOException;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.ModelCreator;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.cats.CATSBidderSetup;
import org.spectrumauctions.sats.core.model.cats.CATSRegionModel;

public class CATSRegionsModelCreator
extends ModelCreator {
    private final int numberOfBidders;
    private final int numberOfGoods;

    protected CATSRegionsModelCreator(Builder builder) {
        super(builder);
        this.numberOfBidders = builder.getNumberOfBidders();
        this.numberOfGoods = builder.getNumberOfGoods();
    }

    @Override
    public PathResult generateResult(File outputFolder) throws UnsupportedBiddingLanguageException, IOException, IllegalConfigException {
        CATSRegionModel model = new CATSRegionModel();
        model.setNumberOfBidders(this.numberOfBidders);
        model.setNumberOfGoods(this.numberOfGoods);
        return this.appendTopLevelParamsAndSolve(model, outputFolder);
    }

    public static class Builder
    extends ModelCreator.Builder {
        private int numberOfBidders = new CATSBidderSetup.Builder().getNumberOfBidders();
        private int numberOfGoods;

        @Override
        public CATSRegionsModelCreator build() {
            return new CATSRegionsModelCreator(this);
        }

        public int getNumberOfBidders() {
            return this.numberOfBidders;
        }

        public void setNumberOfBidders(int numberOfBidders) {
            this.numberOfBidders = numberOfBidders;
        }

        public int getNumberOfGoods() {
            return this.numberOfGoods;
        }

        public void setNumberOfGoods(int numberOfGoods) {
            this.numberOfGoods = numberOfGoods;
        }
    }
}

