/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidfile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.spectrumauctions.sats.core.bidfile.FileWriter;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericLang;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.bidlang.xor.XORLanguage;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Good;

public class JsonExporter
extends FileWriter {
    public static final boolean ONLY_NONZERO_QUANTITIES = true;
    Gson gson;

    public JsonExporter(File path) {
        super(path);
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    @Override
    public File writeMultiBidderXOR(Collection<XORLanguage<Good>> valueFunctions, int numberOfBids, String filePrefix) throws IOException {
        JsonArray json = new JsonArray();
        for (XORLanguage<Good> lang : valueFunctions) {
            JsonObject thisBidder = new JsonObject();
            thisBidder.addProperty("bidder", (Number)lang.getBidder().getId());
            thisBidder.add("bids", this.singleBidderXOR(lang, numberOfBids, filePrefix));
            json.add((JsonElement)thisBidder);
        }
        return this.write((JsonElement)json, filePrefix);
    }

    private JsonElement singleBidderXOR(XORLanguage<Good> lang, int numberOfBids, String filePrefix) {
        JsonArray result = new JsonArray();
        Iterator<XORValue<Good>> iter = lang.iterator();
        for (int i = 0; i < numberOfBids && iter.hasNext(); ++i) {
            JsonObject bid = new JsonObject();
            XORValue<Good> xorValue = iter.next();
            JsonArray licenses = new JsonArray();
            for (Good license : xorValue.getLicenses()) {
                licenses.add((Number)license.getId());
            }
            bid.add("licenses", (JsonElement)licenses);
            bid.addProperty("value", this.roundedValue(xorValue.value().doubleValue()));
            result.add((JsonElement)bid);
        }
        return result;
    }

    @Override
    public File writeSingleBidderXOR(XORLanguage<Good> valueFunction, int numberOfBids, String filePrefix) throws IOException {
        JsonElement singleBidder = this.singleBidderXOR(valueFunction, numberOfBids, filePrefix);
        return this.write(singleBidder, filePrefix);
    }

    @Override
    public File writeMultiBidderXORQ(Collection<GenericLang<GenericDefinition>> valueFunctions, int numberOfBids, String filePrefix) throws IOException {
        JsonArray json = new JsonArray();
        for (GenericLang<GenericDefinition> lang : valueFunctions) {
            JsonObject thisBidder = new JsonObject();
            thisBidder.addProperty("bidder", (Number)lang.getBidder().getId());
            thisBidder.add("bids", this.singleBidderXORQ(lang, numberOfBids, filePrefix));
            json.add((JsonElement)thisBidder);
        }
        return this.write((JsonElement)json, filePrefix);
    }

    @Override
    public File writeSingleBidderXORQ(GenericLang<GenericDefinition> lang, int numberOfBids, String filePrefix) throws IOException {
        JsonElement singleBidder = this.singleBidderXORQ(lang, numberOfBids, filePrefix);
        return this.write(singleBidder, filePrefix);
    }

    private JsonElement singleBidderXORQ(GenericLang<GenericDefinition> lang, int numberOfBids, String filePrefix) {
        JsonArray result = new JsonArray();
        Iterator<GenericValue<GenericDefinition>> iter = lang.iterator();
        for (int i = 0; i < numberOfBids && iter.hasNext(); ++i) {
            JsonObject bid = new JsonObject();
            GenericValue<GenericDefinition> val = iter.next();
            JsonArray quantities = new JsonArray();
            for (Map.Entry quant : val.getQuantities().entrySet()) {
                if ((Integer)quant.getValue() == 0) continue;
                JsonObject object = new JsonObject();
                object.add("generic definition", ((GenericDefinition)quant.getKey()).shortJson());
                object.addProperty("quantity", (Number)quant.getValue());
                quantities.add((JsonElement)object);
            }
            bid.add("quantities", (JsonElement)quantities);
            bid.addProperty("value", this.roundedValue(val.getValue().doubleValue()));
            result.add((JsonElement)bid);
        }
        return result;
    }

    private File write(JsonElement toWrite, String filePrefix) throws IOException {
        Path file = this.nextNonexistingFile(filePrefix);
        String content = this.gson.toJson(toWrite);
        Files.write(file, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
        return file.toFile();
    }

    @Override
    protected String filetype() {
        return "json";
    }
}

