/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;

public abstract class DeterministicIncreasingSizeComparator<T extends GenericDefinition>
implements Comparator<Set<T>>,
Serializable {
    @Override
    public int compare(Set<T> o1, Set<T> o2) {
        Preconditions.checkNotNull(o1);
        Preconditions.checkNotNull(o2);
        int difference = o1.size() - o2.size();
        if (difference != 0) {
            return difference;
        }
        return this.compareSameSize(o1, o2);
    }

    private int compareSameSize(Set<T> o1, Set<T> o2) {
        Preconditions.checkArgument((o1.size() == o2.size() ? 1 : 0) != 0);
        ArrayList<T> o1List = new ArrayList<T>(o1);
        o1List.sort(this.getDefintionComparator());
        ArrayList<T> o2List = new ArrayList<T>(o2);
        o2List.sort(this.getDefintionComparator());
        for (int i = 0; i < o1List.size(); ++i) {
            int comparison = this.getDefintionComparator().compare(o1List.get(i), o2List.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    protected abstract Comparator<T> getDefintionComparator();
}

