/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeOrdered;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public abstract class GenericSizeDecreasing<T extends GenericDefinition>
extends GenericSizeOrdered<T> {
    protected GenericSizeDecreasing(Collection<T> allPossibleGenericDefintions) throws UnsupportedBiddingLanguageException {
        super(allPossibleGenericDefintions);
    }

    @Override
    public Iterator<GenericValue<T>> iterator() {
        return new DecreasingIterator();
    }

    private class DecreasingIterator
    implements Iterator<GenericValue<T>> {
        private Iterator<Set<T>> definitionPowersetIterator;
        int round = 0;
        private Map<T, Integer> roundSize;
        private boolean hasNext;

        protected DecreasingIterator() {
            this.initNextRound();
        }

        private void initNextRound() {
            this.roundSize = new HashMap();
            for (GenericDefinition def : GenericSizeDecreasing.this.allDefintions) {
                int quantity = def.numberOfLicenses() - this.round;
                if (quantity < 0) {
                    quantity = 0;
                }
                this.roundSize.put(def, quantity);
            }
            ++this.round;
            this.initPowersetIterator();
        }

        private void initPowersetIterator() {
            HashSet<GenericDefinition> leftOverQuantities = new HashSet<GenericDefinition>();
            for (GenericDefinition def : GenericSizeDecreasing.this.allDefintions) {
                if (this.roundSize.get(def) <= 0) continue;
                leftOverQuantities.add(def);
            }
            if (leftOverQuantities.size() == 0) {
                this.hasNext = false;
                return;
            }
            this.hasNext = true;
            Set definitionPowerset = Sets.powerSet(leftOverQuantities);
            ArrayList sorted = new ArrayList(definitionPowerset);
            sorted.sort(GenericSizeDecreasing.this.getIncreasingSizeComparator());
            this.definitionPowersetIterator = sorted.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public GenericValue<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            GenericValue.Builder<GenericDefinition> val = new GenericValue.Builder<GenericDefinition>(GenericSizeDecreasing.this.getGenericBidder());
            Set toSubstract = this.definitionPowersetIterator.next();
            for (GenericDefinition def : GenericSizeDecreasing.this.allDefintions) {
                int quantity = this.roundSize.get(def);
                if (toSubstract.contains(def)) {
                    --quantity;
                }
                val.putQuantity(def, quantity);
            }
            if (!this.definitionPowersetIterator.hasNext()) {
                this.initNextRound();
            }
            return val.build();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

