/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.xor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import org.spectrumauctions.sats.core.bidlang.xor.SizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;

public class IncreasingSizeOrderedXOR<T extends Good>
extends SizeOrderedXOR<T> {
    public IncreasingSizeOrderedXOR(Collection<T> goods, Bidder<T> bidder) {
        super(goods, bidder);
    }

    @Override
    public Iterator<XORValue<T>> iterator() {
        return new IncreasingIterator();
    }

    private class IncreasingIterator
    implements Iterator<XORValue<T>> {
        BigInteger index = BigInteger.ONE;
        BigInteger maxIntex;

        private IncreasingIterator() {
            this.maxIntex = BigInteger.valueOf(2L).pow(IncreasingSizeOrderedXOR.this.goods.size());
        }

        @Override
        public boolean hasNext() {
            return this.index.compareTo(this.maxIntex) < 0;
        }

        @Override
        public XORValue<T> next() {
            Bundle bundle = IncreasingSizeOrderedXOR.this.getBundle(this.index);
            this.index = this.index.add(BigInteger.ONE);
            return new XORValue(bundle, IncreasingSizeOrderedXOR.this.getValue(bundle));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

