/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.xor;

import com.google.common.math.BigIntegerMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spectrumauctions.sats.core.bidlang.xor.XORLanguage;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;

public abstract class SizeOrderedXOR<T extends Good>
implements XORLanguage<T> {
    final List<T> goods = new ArrayList<T>();
    private Bidder<T> bidder;

    protected SizeOrderedXOR(Collection<T> goods, Bidder<T> bidder) {
        this.goods.addAll(goods);
        this.bidder = bidder;
    }

    public Bidder<T> getBidder() {
        return this.bidder;
    }

    public Bundle<T> getBundle(BigInteger index) {
        String bundleRepresentation = SizeOrderedXOR.packageRepresentation(index, this.goods.size()).toString();
        return this.getBundle(bundleRepresentation);
    }

    private Bundle<T> getBundle(String bundleRepresentation) {
        Bundle<Good> result = new Bundle<Good>();
        for (int i = 0; i < bundleRepresentation.length(); ++i) {
            if (bundleRepresentation.charAt(i) != '1') continue;
            result.add((Good)this.goods.get(i));
        }
        return result;
    }

    protected BigDecimal getValue(Bundle bundle) {
        return this.getBidder().calculateValue(bundle);
    }

    public Bundle<T> getBundle(BigInteger subIndex, int size) {
        String binaryString = SizeOrderedXOR.recBinaryString(subIndex, this.goods.size(), size).toString();
        return this.getBundle(binaryString);
    }

    public static StringBuilder packageRepresentation(BigInteger index, int n) {
        SizeStarter foundSize = SizeOrderedXOR.bundleSize(index, n);
        BigInteger sizeBasedIndex = index.subtract(foundSize.sizeStart);
        return SizeOrderedXOR.recBinaryString(sizeBasedIndex, n, foundSize.size);
    }

    private static SizeStarter bundleSize(BigInteger index, int n) {
        BigInteger sum = BigInteger.ZERO;
        BigInteger previousSum = null;
        int size = 0;
        while (sum.compareTo(index) < 0) {
            if (++size > n) {
                throw new RuntimeException("Index to big for available number of items: index=" + index.toString());
            }
            BigInteger thisSizeBundles = BigIntegerMath.binomial((int)n, (int)size);
            previousSum = sum;
            sum = sum.add(thisSizeBundles);
        }
        return new SizeStarter(size, previousSum);
    }

    private static StringBuilder recBinaryString(BigInteger sizeBasedIndex, int n, int k) {
        if (n == 0) {
            return new StringBuilder();
        }
        if (k == 0) {
            return new StringBuilder("0").append((CharSequence)SizeOrderedXOR.recBinaryString(sizeBasedIndex, n - 1, 0));
        }
        BigInteger bin = BigIntegerMath.binomial((int)n, (int)k);
        BigInteger biggestOneStarterIndex = bin.multiply(BigInteger.valueOf(k)).divide(BigInteger.valueOf(n));
        if (sizeBasedIndex.compareTo(biggestOneStarterIndex) <= 0) {
            return new StringBuilder("1").append((CharSequence)SizeOrderedXOR.recBinaryString(sizeBasedIndex, n - 1, k - 1));
        }
        BigInteger newIndex = sizeBasedIndex.subtract(biggestOneStarterIndex);
        if (n == k) {
            System.out.println("Problem!!!" + newIndex.toString() + " " + n + " " + k);
        }
        return new StringBuilder("0").append((CharSequence)SizeOrderedXOR.recBinaryString(newIndex, n - 1, k));
    }

    private static class SizeStarter {
        private final BigInteger sizeStart;
        private final int size;

        public SizeStarter(int size, BigInteger sizeStart) {
            this.sizeStart = sizeStart;
            this.size = size;
        }
    }
}

