/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.model.BidderSetup;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.bvm.BMBand;
import org.spectrumauctions.sats.core.util.PreconditionUtils;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public abstract class BMBidderSetup
extends BidderSetup {
    protected final Map<String, IntegerInterval> positiveValueThresholdIntervals;
    protected final Map<String, DoubleInterval> baseValueIntervals;
    protected final Map<String, ImmutableMap<Integer, BigDecimal>> synFactors;

    protected BMBidderSetup(BMBidderSetupBuilder builder) {
        super(builder);
        this.positiveValueThresholdIntervals = ImmutableMap.copyOf(builder.positiveValueThresholdIntervals);
        this.baseValueIntervals = ImmutableMap.copyOf(builder.baseValueIntervals);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Map<Integer, BigDecimal>> entry : builder.synFactors.entrySet()) {
            mapBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.synFactors = mapBuilder.build();
    }

    public Integer drawPositiveValueThreshold(BMBand band, UniformDistributionRNG rng) {
        IntegerInterval interval = this.positiveValueThresholdIntervals.get(band.getName());
        if (interval == null) {
            throw new IncompatibleWorldException("Band name unknown to Bidder Setup");
        }
        return rng.nextInt(interval);
    }

    public BigDecimal drawBaseValue(BMBand band, UniformDistributionRNG rng) {
        DoubleInterval interval = this.baseValueIntervals.get(band.getName());
        if (interval == null) {
            throw new IncompatibleWorldException("Band name unknown to Bidder Setup");
        }
        return rng.nextBigDecimal(interval);
    }

    public Map<Integer, BigDecimal> drawSynergyFactors(BMBand band, UniformDistributionRNG rng) {
        Map bandSynergies = (Map)this.synFactors.get(band.getName());
        if (bandSynergies == null) {
            throw new IncompatibleWorldException("Band name unknown to Bidder Setup ");
        }
        return Collections.unmodifiableMap(bandSynergies);
    }

    public static abstract class BMBidderSetupBuilder
    extends BidderSetup.Builder {
        protected Map<String, IntegerInterval> positiveValueThresholdIntervals = new HashMap<String, IntegerInterval>();
        protected Map<String, DoubleInterval> baseValueIntervals = new HashMap<String, DoubleInterval>();
        protected Map<String, Map<Integer, BigDecimal>> synFactors = new HashMap<String, Map<Integer, BigDecimal>>();

        protected BMBidderSetupBuilder(String setupName, int numberOfBidders) {
            super(setupName, numberOfBidders);
        }

        protected void putValueThresholdInterval(String bandName, IntegerInterval interval) {
            PreconditionUtils.checkNotNull(bandName, interval);
            Preconditions.checkArgument((boolean)interval.isNonNegative());
            this.positiveValueThresholdIntervals.put(bandName, interval);
        }

        protected IntegerInterval removeValueThresholdInterval(String bandName) {
            return this.positiveValueThresholdIntervals.remove(bandName);
        }

        public void putBaseValueInterval(String bandName, DoubleInterval interval) {
            PreconditionUtils.checkNotNull(bandName, interval);
            Preconditions.checkArgument((boolean)interval.isNonNegative());
            this.baseValueIntervals.put(bandName, interval);
        }

        public DoubleInterval removeBaseValueInterval(String bandName) {
            return this.baseValueIntervals.remove(bandName);
        }

        public void putSynergyFactors(String bandName, Map<Integer, BigDecimal> synergies) {
            PreconditionUtils.checkNotNull(bandName, synergies);
            this.synFactors.put(bandName, synergies);
        }

        public Map<Integer, BigDecimal> removeSynergyFactor(String bandName) {
            return this.synFactors.remove(bandName);
        }

        public Map<String, IntegerInterval> getPositiveValueThresholdIntervals() {
            return Collections.unmodifiableMap(this.positiveValueThresholdIntervals);
        }

        public Map<String, DoubleInterval> getBaseValueIntervals() {
            return Collections.unmodifiableMap(this.baseValueIntervals);
        }

        public Map<String, Map<Integer, BigDecimal>> getSynFactors() {
            HashMap synFactors = new HashMap();
            for (Map.Entry entry : synFactors.entrySet()) {
                synFactors.put(entry.getKey(), Collections.unmodifiableMap((Map)entry.getValue()));
            }
            return Collections.unmodifiableMap(synFactors);
        }

        @Override
        public abstract BMBidderSetup build();
    }
}

