/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import java.util.List;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowerset;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.bvm.BMBand;
import org.spectrumauctions.sats.core.model.bvm.BMBidder;

public class SizeOrderedGenericPowersetFactory {
    public static GenericPowerset<BMBand> getSizeOrderedGenericLang(boolean increasing, BMBidder bidder) throws UnsupportedBiddingLanguageException {
        List<BMBand> bands = bidder.getWorld().getBands();
        if (increasing) {
            return new Increasing(bands, bidder);
        }
        return new Decreasing(bands, bidder);
    }

    private static final class Decreasing
    extends GenericPowersetDecreasing<BMBand> {
        private BMBidder bidder;

        protected Decreasing(List<BMBand> genericDefinitions, BMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(genericDefinitions);
            this.bidder = bidder;
        }

        @Override
        public Bidder<? extends Good> getBidder() {
            return this.bidder;
        }

        @Override
        protected GenericValueBidder<BMBand> getGenericBidder() {
            return this.bidder;
        }
    }

    private static final class Increasing
    extends GenericPowersetIncreasing<BMBand> {
        private BMBidder bidder;

        protected Increasing(List<BMBand> genericDefinitions, BMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(genericDefinitions);
            this.bidder = bidder;
        }

        public BMBidder getBidder() {
            return this.bidder;
        }

        @Override
        protected GenericValueBidder<BMBand> getGenericBidder() {
            return this.bidder;
        }
    }
}

