/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats;

import com.google.common.base.Preconditions;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Mesh2D;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class CATSWorldSetup {
    private final IntegerInterval numberOfRowsInterval;
    private final IntegerInterval numberOfColumnInterval;
    private final IntegerInterval numberOfGoodsInterval;
    private final DoubleInterval commonValueInterval;
    private final double threeProb;
    private final double additionalNeigh;
    private final double additivity;
    private final boolean useQuadraticPricingOption;

    private CATSWorldSetup(Builder builder) {
        this.numberOfRowsInterval = builder.numberOfRowsInterval;
        this.numberOfColumnInterval = builder.numberOfColumnsInterval;
        this.numberOfGoodsInterval = builder.numberOfGoodsInterval;
        this.threeProb = builder.threeProb;
        this.additionalNeigh = builder.additionalNeigh;
        this.commonValueInterval = builder.commonValueInterval;
        this.additivity = builder.additivity;
        this.useQuadraticPricingOption = builder.useQuadraticPricingOption;
    }

    public double getAdditivity() {
        return this.additivity;
    }

    public boolean hasDefinedNumberOfGoodsInterval() {
        return this.numberOfGoodsInterval != null;
    }

    Integer drawNumberOfRows(RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        return rng.nextInt(this.numberOfRowsInterval);
    }

    Integer drawNumberOfColumns(RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        return rng.nextInt(this.numberOfColumnInterval);
    }

    Integer drawNumberOfGoods(RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        return rng.nextInt(this.numberOfGoodsInterval);
    }

    Double drawCommonValue(RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        return rng.nextDouble(this.commonValueInterval);
    }

    Mesh2D buildProximityGraph(int _numberOfRows, int _numberOfColumns, RNGSupplier rngSupplier) {
        Mesh2D _graph = new Mesh2D(_numberOfRows, _numberOfColumns);
        UniformDistributionRNG generator = rngSupplier.getUniformDistributionRNG();
        for (int n = 0; n < _numberOfRows * _numberOfColumns; ++n) {
            if ((n + 1) % _numberOfColumns == 0 || (n + 1) % _numberOfColumns == 1 || (n + 1) / _numberOfColumns == 0 || n / _numberOfColumns == _numberOfRows - 1) continue;
            if (generator.nextDouble() <= this.threeProb) {
                int numberOfAdjacentNeighs = _graph.getAdjacencyLists().get(n).size();
                int edgeToRemove = (int)(generator.nextDouble() * (double)numberOfAdjacentNeighs);
                _graph.removeEdge(n + 1, edgeToRemove);
            }
            for (int numberOfDNeigh = 0; generator.nextDouble() <= this.additionalNeigh && numberOfDNeigh < 4; ++numberOfDNeigh) {
                int newDNeigh = 0;
                if (numberOfDNeigh == 0) {
                    newDNeigh = n + 1 - _numberOfColumns - 1;
                } else if (numberOfDNeigh == 1) {
                    newDNeigh = n + 1 - _numberOfColumns + 1;
                } else if (numberOfDNeigh == 2) {
                    newDNeigh = n + 1 + _numberOfColumns + 1;
                } else if (numberOfDNeigh == 3) {
                    newDNeigh = n + 1 + _numberOfColumns - 1;
                }
                _graph.addEdge(n + 1, newDNeigh);
            }
        }
        return _graph;
    }

    public boolean useQuadraticPricingOption() {
        return this.useQuadraticPricingOption;
    }

    public static class Builder {
        private static final int DEFAULT_NUMBER_OF_ROWS = 16;
        private static final int DEFAULT_NUMBER_OF_COLUMNS = 16;
        private static final double DEFAULT_THREE_PROB = 1.0;
        private static final double DEFAULT_ADDITIONAL_NEIGHBOR = 0.2;
        private static final double DEFAULT_ADDITIVITY = 0.2;
        private static final boolean DEFAULT_QUADRATIC_PRICING_FLAG = false;
        private static final double DEFAULT_MAX_GOOD_VALUE = 100.0;
        private static final double DEFAULT_COMMON_VALUE_MIN = 1.0;
        private static final double DEFAULT_COMMON_VALUE_MAX = 100.0;
        private static final double DEFAULT_MAX_SUBSTITUTABLE_BIDS = 5.0;
        private static final double DEFAULT_ADDITIONAL_LOCATION = 0.9;
        private static final double DEFAULT_JUMP_PROB = 0.05;
        private static final double DEFAULT_DEVIATION = 0.5;
        private static final double DEFAULT_BUDGET_FACTOR = 1.5;
        private static final double DEFAULT_RESALE_FACTOR = 0.5;
        private DoubleInterval commonValueInterval;
        private IntegerInterval numberOfRowsInterval = new IntegerInterval(16);
        private IntegerInterval numberOfColumnsInterval = new IntegerInterval(16);
        private IntegerInterval numberOfGoodsInterval;
        private double threeProb = 1.0;
        private double additionalNeigh = 0.2;
        private double additivity = 0.2;
        private boolean useQuadraticPricingOption = false;

        public Builder() {
            this.commonValueInterval = new DoubleInterval(1.0, 100.0);
        }

        public void setNumberOfRowsInterval(IntegerInterval numberOfRowsInterval) {
            Preconditions.checkArgument((numberOfRowsInterval.getMinValue() > 0 ? 1 : 0) != 0);
            this.numberOfRowsInterval = numberOfRowsInterval;
        }

        public void setNumberOfColumnsInterval(IntegerInterval numberOfColumnsInterval) {
            Preconditions.checkArgument((numberOfColumnsInterval.getMinValue() > 0 ? 1 : 0) != 0);
            this.numberOfColumnsInterval = numberOfColumnsInterval;
        }

        public void setNumberOfGoodsInterval(IntegerInterval NumberOfGoodsInterval) {
            Preconditions.checkArgument((this.numberOfColumnsInterval.getMinValue() > 0 ? 1 : 0) != 0);
            this.numberOfGoodsInterval = NumberOfGoodsInterval;
        }

        public void setCommonValueInterval(DoubleInterval commonValueInterval) {
            Preconditions.checkArgument((commonValueInterval.getMinValue() >= 0.0 ? 1 : 0) != 0);
            this.commonValueInterval = commonValueInterval;
        }

        public void setThreeProb(double threeProb) {
            this.threeProb = threeProb;
        }

        public void setAdditionalNeigh(double additionalNeigh) {
            this.additionalNeigh = additionalNeigh;
        }

        public void setAdditivity(double additivity) {
            this.additivity = additivity;
        }

        public void setUseQuadraticPricingOption(boolean bool) {
            this.useQuadraticPricingOption = bool;
        }

        public CATSWorldSetup build() {
            return new CATSWorldSetup(this);
        }
    }
}

