/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats.graphalgorithms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Edge;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.PriorityQueueMin;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Vertex;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.VertexCell;

public class Graph {
    protected List<List<VertexCell>> _adjacencyLists = new LinkedList<List<VertexCell>>();
    private Vertex _source;
    protected List<Vertex> _vertices;
    private List<Edge> _edges;
    private double _radius;
    private double[][][] _flowTables;
    private static final int WHITE = 0;
    private static final int GREY = 1;
    private static final int BLACK = 2;

    public Graph(List<Vertex> vertices, List<VertexCell> ... adjLst) {
        this._edges = new LinkedList<Edge>();
        this._vertices = vertices;
        this._radius = 0.0;
        Collections.addAll(this._adjacencyLists, adjLst);
    }

    public Graph(List<Vertex> vertices, List<List<VertexCell>> adjLsts) {
        this._edges = new LinkedList<Edge>();
        this._vertices = new LinkedList<Vertex>();
        this._radius = 0.0;
        this._vertices.addAll(vertices);
        this._adjacencyLists.addAll(adjLsts);
    }

    public Graph(List<Vertex> vertices) {
        this._vertices = vertices;
        this._radius = 0.0;
    }

    public Graph() {
        this._vertices = new LinkedList<Vertex>();
        this._edges = new LinkedList<Edge>();
        this._radius = 0.0;
    }

    public int getNumberOfEdges() {
        return this._adjacencyLists.stream().map(List::size).reduce((x1, x2) -> x1 + x2).get();
    }

    public List<Vertex> getVertices() {
        return this._vertices;
    }

    public List<List<VertexCell>> getAdjacencyLists() {
        return this._adjacencyLists;
    }

    public List<Edge> getEdges() {
        if (this._edges.size() <= 0) {
            this.constructListOfEdges(0);
        }
        return this._edges;
    }

    public void addListOfVertices(List<Vertex> vrts) {
        this._vertices = vrts;
    }

    public void addAdjacencyList(List<VertexCell> adjLst) {
        this._adjacencyLists.add(adjLst);
    }

    public String toString() {
        String str = "Graph:\n";
        int i = 1;
        for (List<VertexCell> vList : this._adjacencyLists) {
            str = str + this._vertices.get(i - 1).getID() + " | ";
            for (VertexCell v : vList) {
                str = str + "->" + v.toString() + " f=" + v._f;
            }
            str = str + "\n";
            ++i;
        }
        for (Vertex v : this._vertices) {
            str = str + " {ID=" + v.getID() + " Pi=" + v.getPredecessor(0) + " Sh.Est" + v.getShortestPathEst(0) + " }";
        }
        str = str + "\n" + this.generateGEXF();
        return str;
    }

    private String generateGEXF() {
        String gexf = "";
        gexf = gexf + "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
        gexf = gexf + "<gexf xmlns=\"http://www.gexf.net/1.2draft\"\n";
        gexf = gexf + "      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
        gexf = gexf + "      xsi:schemaLocation=\"http://www.gexf.net/1.2draft\n";
        gexf = gexf + "                           http://www.gexf.net/1.2draft/gexf.xsd\"\n";
        gexf = gexf + "      version=\"1.2\"\n";
        gexf = gexf + "  <meta lastmodifieddate=\"2009-03-20\">\n";
        gexf = gexf + "    <creator>Gephi.org</creator>\n";
        gexf = gexf + "    <description>Graph representation</description>\n";
        gexf = gexf + "    <keywords>Graph</keywords>\n";
        gexf = gexf + "  </meta>\n";
        gexf = gexf + "  <nodes>\n";
        for (Vertex v : this._vertices) {
            gexf = gexf + "    <node id=\"" + v.getID() + "\" label=\"" + v.getID() + "\" />\n";
        }
        gexf = gexf + "  </nodes>\n";
        gexf = gexf + "  <edges>\n";
        for (int i = 0; i < this._vertices.size(); ++i) {
            Vertex src = this._vertices.get(i);
            for (VertexCell vc : this._adjacencyLists.get(i)) {
                gexf = gexf + "    <edge id=\"" + src.getID() + "" + vc._v.getID() + "\" source=\"" + src.getID() + "\" target=\"" + vc._v.getID() + "\" />\n";
            }
        }
        gexf = gexf + "  </edges>\n";
        gexf = gexf + "</gexf>\n";
        return gexf;
    }

    public int getOutputDegree(int vertexId) {
        return this._adjacencyLists.get(vertexId - 1).size();
    }

    public long getInputDegree(int vertexId) {
        return this._adjacencyLists.stream().flatMap(Collection::stream).filter(vc -> vc._v.getID() == vertexId).count();
    }

    public int getVertexPredecessor(int vertexID) {
        for (Vertex v : this._vertices) {
            if (v.getID() != vertexID) continue;
            return v.getPredecessor(0);
        }
        return 0;
    }

    public List<VertexCell> getPath(Vertex v, Vertex u) {
        if (u.getPredecessor(0) == 0) {
            throw new RuntimeException("No Path from v to u exists. v=" + v.getID() + " u=" + u.getID() + " " + this.toString());
        }
        LinkedList<VertexCell> path = new LinkedList<VertexCell>();
        Vertex next = u;
        u = this._vertices.get(u.getPredecessor(0) - 1);
        while (u.getID() != v.getID()) {
            for (VertexCell vc : this._adjacencyLists.get(u.getID() - 1)) {
                if (vc._v != next) continue;
                path.add(vc);
            }
            next = u;
            u = this._vertices.get(u.getPredecessor(0) - 1);
        }
        for (VertexCell vc : this._adjacencyLists.get(u.getID() - 1)) {
            if (vc._v != next) continue;
            path.add(vc);
        }
        return path;
    }

    public double[][][] getFlowTables() {
        return this._flowTables;
    }

    public double getRadius(Vertex v, boolean recompute) {
        if (!recompute) {
            return this._radius;
        }
        this.Dijkstra(v, 0);
        this._radius = 0.0;
        for (Vertex vrt : this._vertices) {
            if (vrt.getPredecessor(0) <= 0 || !(vrt.getShortestPathEst(0) > this._radius)) continue;
            this._radius = vrt.getShortestPathEst(0);
        }
        return this._radius;
    }

    public Graph getBall(Vertex center, double radius, boolean recompute) {
        if (recompute) {
            this.Dijkstra(center, 0);
        }
        LinkedList<Vertex> vertices = new LinkedList<Vertex>();
        LinkedList<List<VertexCell>> adjLists = new LinkedList<List<VertexCell>>();
        LinkedList<List<VertexCell>> adjListsNew = new LinkedList<List<VertexCell>>();
        int curVertex = 0;
        for (Vertex vertex : this._vertices) {
            if (vertex.getShortestPathEst(0) < radius || Math.abs(vertex.getShortestPathEst(0) - radius) < 1.0E-6) {
                vertices.add(vertex);
                adjLists.add(this._adjacencyLists.get(curVertex));
            }
            ++curVertex;
        }
        for (List list : adjLists) {
            LinkedList<VertexCell> newAdjList = new LinkedList<VertexCell>();
            for (VertexCell vc : list) {
                if (!vertices.contains(vc._v)) continue;
                newAdjList.add(vc);
            }
            adjListsNew.add(newAdjList);
        }
        Graph ball = new Graph((List<Vertex>)vertices, (List<List<VertexCell>>)adjListsNew);
        return ball;
    }

    public List<Vertex> getBallShell(Vertex center, double radius, boolean recompute) {
        if (recompute) {
            this.Dijkstra(center, 0);
        }
        LinkedList<Vertex> vertices = new LinkedList<Vertex>();
        LinkedList<List<VertexCell>> adjLists = new LinkedList<List<VertexCell>>();
        LinkedList<Vertex> ballShell = new LinkedList<Vertex>();
        int curVertex = 0;
        for (Vertex vertex : this._vertices) {
            if (vertex.getShortestPathEst(0) < radius || Math.abs(vertex.getShortestPathEst(0) - radius) < 1.0E-6) {
                vertices.add(vertex);
                adjLists.add(this._adjacencyLists.get(curVertex));
            }
            ++curVertex;
        }
        for (List list : adjLists) {
            for (VertexCell vc : list) {
                if (vertices.contains(vc._v) || ballShell.contains(vc._v)) continue;
                ballShell.add(vc._v);
            }
        }
        return ballShell;
    }

    public List<Edge> getBoundary(List<Vertex> vertices) {
        LinkedList<Edge> boundary = new LinkedList<Edge>();
        for (Vertex v : vertices) {
            for (VertexCell vc : this._adjacencyLists.get(v.getAdjacencyListIndex())) {
                if (vertices.contains(vc._v)) continue;
                boundary.add(new Edge(v, vc._v, vc._w, 0));
            }
        }
        return boundary;
    }

    public List<Vertex> getCone(Vertex center, double radius, List<Vertex> S) {
        LinkedList<Vertex> cone = new LinkedList<Vertex>();
        this.Dijkstra(center, 0);
        int counter = 1;
        for (Vertex v : S) {
            if (v.equals(center)) continue;
            this.Dijkstra(v, counter);
            ++counter;
        }
        for (Vertex v : this._vertices) {
            int localCounter = 0;
            for (int i = 1; i < S.size(); ++i) {
                if (!(v.getShortestPathEst(0) < v.getShortestPathEst(i) + radius) || cone.contains(v)) continue;
                ++localCounter;
            }
            if (localCounter != S.size() - 1) continue;
            cone.add(v);
        }
        return cone;
    }

    public double computeCost(List<Edge> edges) {
        double cost = 0.0;
        for (Edge e : edges) {
            cost += 1.0 / e.getCapacity();
        }
        return cost;
    }

    public double BallCut(Vertex x, double rad, double delta) {
        double r = rad * delta;
        int m = this._edges.size() / 2;
        while (this.computeCost(this.getBoundary(this.getBall(x, r, false).getVertices())) > (double)(this.getBall(x, r, false).getVertices().size() + 1) * (Math.log(m + 1) / Math.log(2.0)) / ((1.0 - 2.0 * delta) * rad)) {
            double curDist = Double.MAX_VALUE;
            for (Vertex v : this._vertices) {
                if (this.getBall(x, r, false).getVertices().contains(v) || !(v.getShortestPathEst(0) < curDist)) continue;
                curDist = v.getShortestPathEst(0);
            }
            r = curDist;
        }
        return r;
    }

    public double ConeCut(Vertex center, double lambda, double lambda1, List<Vertex> S) {
        double r = lambda;
        double mue = 0.0;
        Graph Cs = this.induceGraph(this.getCone(center, lambda, S));
        mue = Cs.getNumberOfEdges() == 0 ? (double)(Cs.getVertices().size() + 1) * Math.log(this.getNumberOfEdges() + 1) / Math.log(2.0) : (double)Cs.getVertices().size() * Math.log(this.getNumberOfEdges() / Cs.getNumberOfEdges()) / Math.log(2.0);
        while (this.computeCost(this.getBoundary(this.getCone(center, r, S))) > mue / (lambda1 - lambda)) {
            double curDist = Double.MAX_VALUE;
            for (Vertex v : this._vertices) {
                if (this.getCone(center, r, S).contains(v) || !(v.getShortestPathEst() < curDist)) continue;
                curDist = v.getShortestPathEst();
            }
            r += curDist;
        }
        return r;
    }

    public List<List<Vertex>> coneDecomp(List<Vertex> S, double delta, List<Vertex> coneVertices) {
        Graph Gk = new Graph(this.getVertices(), this.getAdjacencyLists());
        LinkedList<List<Vertex>> res = new LinkedList<List<Vertex>>();
        while (S.size() > 0) {
            Vertex x = S.get((int)Math.floor((double)S.size() * Math.random()));
            coneVertices.add(x);
            double r = Gk.ConeCut(x, 0.0, delta, S);
            List<Vertex> Vk = Gk.getCone(x, r, S);
            res.add(Vk);
            Gk.getVertices().removeAll(Vk);
            Gk = Gk.induceGraph(Gk.getVertices());
            S.removeAll(Vk);
            if (S.size() != 1) continue;
            res.add(Gk.getVertices());
            coneVertices.add(S.get(0));
            break;
        }
        return res;
    }

    public List<List<Vertex>> starDecomp(Vertex x0, double delta, double epsilon, List<Vertex> y, List<Vertex> coneVertices) {
        double r0;
        double rad = this.getRadius(x0, true);
        if (rad == (r0 = this.BallCut(x0, rad, delta))) {
            LinkedList<List<Vertex>> star = new LinkedList<List<Vertex>>();
            star.add(this.getVertices());
            return star;
        }
        Graph B0 = this.getBall(x0, r0, false);
        List<Vertex> BS = this.getBallShell(x0, r0, false);
        LinkedList<Vertex> graphVertices = new LinkedList<Vertex>();
        for (Vertex v : this._vertices) {
            if (B0.getVertices().contains(v)) continue;
            graphVertices.add(v);
        }
        Graph G1 = this.induceGraph(graphVertices);
        List<List<Vertex>> star = G1.coneDecomp(BS, epsilon * rad / 2.0, coneVertices);
        int i = 0;
        for (Vertex ballV : B0.getVertices()) {
            this.Dijkstra(ballV, i++);
        }
        for (Vertex v : coneVertices) {
            int minIdx = 0;
            double minDist = Double.MAX_VALUE;
            for (int j = 0; j < B0.getVertices().size(); ++j) {
                if (!(v.getShortestPathEst(j) < minDist)) continue;
                minDist = v.getShortestPathEst(j);
                minIdx = j;
            }
            y.add(B0.getVertices().get(minIdx));
        }
        star.add(B0.getVertices());
        coneVertices.add(x0);
        return star;
    }

    public Graph induceGraph(List<Vertex> vertices) {
        LinkedList<List<VertexCell>> adjLists = new LinkedList<List<VertexCell>>();
        LinkedList<Vertex> newVertices = new LinkedList<Vertex>();
        int i = 0;
        for (Vertex vertex : vertices) {
            Vertex newV = vertex.cloneIt();
            newV.setAdjacencyListIndex(i);
            LinkedList<VertexCell> adjList = new LinkedList<VertexCell>();
            for (VertexCell vc : this._adjacencyLists.get(vertex.getAdjacencyListIndex())) {
                if (!vertices.contains(vc._v)) continue;
                adjList.add(new VertexCell(vc._v, vc._w, vc._f));
            }
            adjLists.add(adjList);
            newVertices.add(newV);
            ++i;
        }
        for (List list : adjLists) {
            block3: for (VertexCell vc : list) {
                for (Vertex v : newVertices) {
                    if (vc._v.getID() != v.getID()) continue;
                    vc._v = v;
                    continue block3;
                }
            }
        }
        Graph g = new Graph((List<Vertex>)newVertices, (List<List<VertexCell>>)adjLists);
        return g;
    }

    public List<Graph> lowStretchTree(Vertex center, double betta, List<Edge> bridges) {
        int i;
        if (this.getVertices().size() <= 2) {
            LinkedList<Graph> res = new LinkedList<Graph>();
            res.add(this);
            return res;
        }
        double rad = this.getRadius(center, true);
        LinkedList<Vertex> y = new LinkedList<Vertex>();
        LinkedList<Vertex> x = new LinkedList<Vertex>();
        LinkedList<Graph> T = new LinkedList<Graph>();
        List<List<Vertex>> V = this.starDecomp(center, 0.3333333333333333, betta, y, x);
        if (V.size() == 1) {
            if (this.getNumberOfEdges() / 2 == this.getVertices().size() - 1) {
                T.add(this);
                return T;
            }
            if (this.getNumberOfEdges() / 2 == this.getVertices().size()) {
                Vertex peer = this._adjacencyLists.get((int)0).get((int)0)._v;
                for (VertexCell vc : this._adjacencyLists.get(peer.getAdjacencyListIndex())) {
                    if (!vc._v.equals(this._vertices.get(0))) continue;
                    this._adjacencyLists.get(peer.getAdjacencyListIndex()).remove(vc);
                    this._adjacencyLists.get(0).remove(0);
                    break;
                }
                T.add(this);
                return T;
            }
            throw new RuntimeException("Not a tree");
        }
        for (i = 0; i < V.size(); ++i) {
            LinkedList<Vertex> newVList = new LinkedList<Vertex>();
            block2: for (Vertex v : V.get(i)) {
                for (Vertex curV : this._vertices) {
                    if (!curV.equals(v)) continue;
                    newVList.add(curV);
                    continue block2;
                }
            }
            Graph Gi = this.induceGraph(newVList);
            List<Graph> Ti = Gi.lowStretchTree((Vertex)x.get(i), betta, bridges);
            T.addAll(Ti);
        }
        for (i = 0; i < y.size(); ++i) {
            Edge e = new Edge((Vertex)x.get(i), (Vertex)y.get(i), 0);
            bridges.add(e);
        }
        return T;
    }

    public boolean isAdjacent(Vertex u, Vertex v) {
        for (VertexCell vc : this._adjacencyLists.get(u.getID() - 1)) {
            if (vc._v.getID() != v.getID()) continue;
            return true;
        }
        return false;
    }

    public void BFS(Vertex s) {
        for (Vertex v : this._vertices) {
            v.setColor(0);
            v.setPredecessor(0, 0);
            v.setShortestPathEst(Double.MAX_VALUE, 0);
        }
        s.setColor(1);
        s.setPredecessor(0, 0);
        s.setShortestPathEst(0.0, 0);
        LinkedList<Vertex> queue = new LinkedList<Vertex>();
        queue.add(s);
        while (!queue.isEmpty()) {
            Vertex u = (Vertex)queue.remove(0);
            for (VertexCell v : this._adjacencyLists.get(u.getID() - 1)) {
                if (v._v.getColor() != 0) continue;
                v._v.setColor(1);
                v._v.setPredecessor(u.getID(), 0);
                v._v.setShortestPathEst(u.getShortestPathEst(0) + 1.0, 0);
                queue.add(v._v);
            }
            u.setColor(2);
        }
    }

    public void FordFulkerson(Vertex s, Vertex t) {
        for (Vertex v : this._vertices) {
            for (VertexCell vc : this._adjacencyLists.get(v.getID() - 1)) {
                vc._f = 0.0;
            }
        }
        Graph residualNetwork = this.buildResidualNetwork();
        residualNetwork.BFS(s);
        while (residualNetwork.getVertexPredecessor(t.getID()) != 0) {
            List<VertexCell> path = residualNetwork.getPath(s, t);
            double cf = Double.MAX_VALUE;
            for (VertexCell vc : path) {
                if (!(vc._w < cf)) continue;
                cf = vc._w;
            }
            Vertex cur = s;
            Collections.reverse(path);
            for (VertexCell vc : path) {
                for (VertexCell vc1 : this._adjacencyLists.get(cur.getID() - 1)) {
                    if (vc1._v.getID() != vc._v.getID()) continue;
                    vc1._f += cf;
                    break;
                }
                cur = vc._v;
            }
            residualNetwork = this.buildResidualNetwork();
            residualNetwork.BFS(s);
        }
    }

    public boolean BellmanFord(Vertex sourceID, int idx) {
        this.initSingleSource(sourceID, idx);
        for (int i = 1; i <= this._vertices.size() - 1; ++i) {
            for (Vertex u : this._vertices) {
                for (VertexCell vc : this._adjacencyLists.get(u.getID() - 1)) {
                    this.relax(u, vc._v, vc._w, idx);
                }
            }
        }
        for (Vertex u : this._vertices) {
            for (VertexCell vc : this._adjacencyLists.get(u.getID() - 1)) {
                if (!(vc._v.getShortestPathEst(0) > u.getShortestPathEst(0) + vc._w)) continue;
                return false;
            }
        }
        return true;
    }

    public void Dijkstra(Vertex source, int idx) {
        this.initSingleSource(source, idx);
        HashSet<Vertex> processedVertices = new HashSet<Vertex>();
        PriorityQueueMin<VertexCell> queue = new PriorityQueueMin<VertexCell>(this._vertices.size());
        for (Vertex v : this._vertices) {
            queue.insert(new VertexCell(v, 0.0), idx);
        }
        while (!queue.isEmpty()) {
            VertexCell u = (VertexCell)queue.extractMin(idx);
            processedVertices.add(u._v);
            for (VertexCell vc : this._adjacencyLists.get(u._v.getAdjacencyListIndex())) {
                double newKey = this.relax(u._v, vc._v, vc._w, idx);
                if (!(newKey > 0.0)) continue;
                queue.decreaseKey(vc, newKey, idx);
            }
        }
    }

    public Set<Set<Vertex>> findAllPaths(Vertex source, Vertex destination) {
        HashSet<Set<Vertex>> allPaths = new HashSet<Set<Vertex>>();
        Stack<Vertex> path = new Stack<Vertex>();
        HashSet<Vertex> currentPath = new HashSet<Vertex>();
        this.explore(source, destination, path, currentPath, allPaths);
        return allPaths;
    }

    private void explore(Vertex current, Vertex destination, Stack<Vertex> path, Set<Vertex> currentPath, Set<Set<Vertex>> allPaths) {
        path.push(current);
        currentPath.add(current);
        if (current.equals(destination)) {
            allPaths.add(path.stream().collect(Collectors.toSet()));
        } else {
            this.getVertices().stream().filter(v -> this.isAdjacent((Vertex)v, current) && !currentPath.contains(v)).forEach(v -> this.explore((Vertex)v, destination, path, currentPath, allPaths));
        }
        path.pop();
        currentPath.remove(current);
    }

    private void initSingleSource(Vertex sourceID, int idx) {
        this._source = sourceID;
        for (Vertex v : this._vertices) {
            if (v.getID() != this._source.getID()) {
                v.setShortestPathEst(Double.MAX_VALUE, idx);
                v.setPredecessor(0, idx);
                continue;
            }
            v.setPredecessor(0, idx);
            v.setShortestPathEst(0.0, idx);
        }
    }

    private double relax(Vertex u, Vertex v, double w, int idx) {
        if (v.getShortestPathEst(idx) > u.getShortestPathEst(idx) + w) {
            v.setShortestPathEst(u.getShortestPathEst(idx) + w, idx);
            v.setPredecessor(u.getID(), idx);
            return v.getShortestPathEst(idx);
        }
        return 0.0;
    }

    public Graph buildResidualNetwork() {
        Graph g = new Graph(this._vertices);
        for (Vertex v : this._vertices) {
            LinkedList<VertexCell> adjList = new LinkedList<VertexCell>();
            for (Vertex u : this._vertices) {
                double residualCapacity = 0.0;
                if (this.isAdjacent(v, u)) {
                    for (VertexCell vc : this._adjacencyLists.get(v.getID() - 1)) {
                        if (vc._v != u) continue;
                        residualCapacity = vc._w - vc._f;
                    }
                }
                if (this.isAdjacent(u, v)) {
                    for (VertexCell vc : this._adjacencyLists.get(u.getID() - 1)) {
                        if (vc._v != v) continue;
                        residualCapacity += vc._f;
                    }
                }
                if (residualCapacity == 0.0) continue;
                adjList.add(new VertexCell(u, residualCapacity));
            }
            g.addAdjacencyList(adjList);
        }
        return g;
    }

    public void removeEdge(int vertexId, int edgeIdx) {
        int sinkId = this._adjacencyLists.get((int)(vertexId - 1)).get((int)edgeIdx)._v.getID();
        this._adjacencyLists.get(vertexId - 1).remove(edgeIdx);
        for (int i = 0; i < this._adjacencyLists.get(sinkId - 1).size(); ++i) {
            if (this._adjacencyLists.get((int)(sinkId - 1)).get((int)i)._v.getID() != vertexId) continue;
            this._adjacencyLists.get(sinkId - 1).remove(i);
            break;
        }
    }

    public void addEdge(int sourceId, int sinkId) {
        this._adjacencyLists.get(sourceId - 1).add(new VertexCell(this._vertices.get(sinkId - 1), 1.0));
        this._adjacencyLists.get(sinkId - 1).add(new VertexCell(this._vertices.get(sourceId - 1), 1.0));
    }

    public void constructFlowTables(int numberOfFlows) {
        this._flowTables = new double[numberOfFlows][this._vertices.size()][this._vertices.size()];
        for (int i = 0; i < numberOfFlows; ++i) {
            for (int j = 0; j < this._vertices.size(); ++j) {
                for (int k = 0; k < this._vertices.size(); ++k) {
                    this._flowTables[i][j][k] = 0.0;
                }
            }
        }
        for (Edge e : this._edges) {
            for (int i = 0; i < numberOfFlows; ++i) {
                this._flowTables[i][e.getSource().getID() - 1][e.getSink().getID() - 1] = e.getFlow(i);
            }
        }
    }

    private void constructListOfEdges(int numFlowsPerEdge) {
        for (Vertex v : this._vertices) {
            for (VertexCell vc : this._adjacencyLists.get(v.getID() - 1)) {
                this._edges.add(new Edge(v, vc._v, vc._w, numFlowsPerEdge));
            }
        }
    }

    private void normalizeFlows() {
        for (Edge edge : this._edges) {
            for (Edge otherEdge : this._edges) {
                if (!otherEdge.getSink().equals(edge.getSource()) || !otherEdge.getSource().equals(edge.getSink())) continue;
                for (int i = 0; i < edge.getNumberOfFlows(); ++i) {
                    if (edge.getFlow(i) >= otherEdge.getFlow(i)) {
                        edge.setFLow(i, edge.getFlow(i) - otherEdge.getFlow(i));
                        otherEdge.setFLow(i, 0.0);
                        continue;
                    }
                    otherEdge.setFLow(i, otherEdge.getFlow(i) - edge.getFlow(i));
                    edge.setFLow(i, 0.0);
                }
            }
        }
    }
}

