/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats.graphalgorithms;

import java.util.LinkedList;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Graph;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Vertex;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.VertexCell;

public class Mesh2D
extends Graph {
    public Mesh2D(int x, int y) {
        Vertex[] vrts = new Vertex[x * y];
        for (int i = 0; i < x * y; ++i) {
            vrts[i] = new Vertex(i + 1);
        }
        LinkedList<Vertex> vertices = new LinkedList<Vertex>();
        this.addListOfVertices(vertices);
        for (int i = 0; i < x * y; ++i) {
            vertices.add(vrts[i]);
            LinkedList<VertexCell> adjList = new LinkedList<VertexCell>();
            if (vrts[i].getID() % x != 1) {
                adjList.add(new VertexCell(vrts[i - 1], 1.0));
            }
            if (vrts[i].getID() % x != 0) {
                adjList.add(new VertexCell(vrts[i + 1], 1.0));
            }
            if (vrts[i].getID() - x > 0) {
                adjList.add(new VertexCell(vrts[i - x], 1.0));
            }
            if (vrts[i].getID() + x <= x * y) {
                adjList.add(new VertexCell(vrts[i + x], 1.0));
            }
            this.addAdjacencyList(adjList);
        }
    }

    @Override
    public String toString() {
        String str = "MESH ";
        return str + super.toString();
    }
}

