/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats.graphalgorithms;

import java.util.LinkedList;
import java.util.List;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.KeyInterface;

public class PriorityQueueMax<T extends KeyInterface> {
    private List<T> _elements;
    private final int _heapLength;
    private int _heapSize;

    public PriorityQueueMax(int length) {
        this._heapLength = length;
        this._elements = new LinkedList<T>();
        this._heapSize = 0;
    }

    public String toString() {
        String str = "Queue (sz=" + this._heapSize + "):\n";
        for (KeyInterface element : this._elements) {
            str = str + element.toString() + " ";
        }
        return str;
    }

    public boolean isEmpty() {
        return this._heapSize == 0;
    }

    public void insert(T element) {
        ++this._heapSize;
        double key = element.getKey();
        element.setKey(-1.7976931348623157E308);
        this._elements.add(element);
        this.increaseKey(element, this._heapSize - 1, key);
    }

    public T max() {
        return (T)((KeyInterface)this._elements.get(0));
    }

    public T extractMax() {
        if (this._heapSize < 1) {
            throw new RuntimeException("PriorityQueueMax queue is empty");
        }
        KeyInterface max = (KeyInterface)this._elements.get(0);
        this._elements.set(0, this._elements.get(this._heapSize - 1));
        this._elements.remove(this._heapSize - 1);
        --this._heapSize;
        this.maxHeapify(0);
        return (T)max;
    }

    private void increaseKey(T element, int position, double key) {
        if (key < element.getKey()) {
            throw new RuntimeException("Wrong key");
        }
        element.setKey(key);
        while (position > 0 && ((KeyInterface)this._elements.get((int)Math.floor((position - 1) / 2))).getKey() < ((KeyInterface)this._elements.get(position)).getKey()) {
            int parent = (int)Math.floor((position - 1) / 2);
            KeyInterface tmp = (KeyInterface)this._elements.get(parent);
            this._elements.set(parent, this._elements.get(position));
            this._elements.set(position, tmp);
            position = parent;
        }
    }

    private void maxHeapify(int i) {
        int l = 2 * (i + 1) - 1;
        int r = 2 * (i + 1);
        int largest = i;
        largest = l <= this._heapSize - 1 && ((KeyInterface)this._elements.get(l)).getKey() > ((KeyInterface)this._elements.get(i)).getKey() ? l : i;
        if (r <= this._heapSize - 1 && ((KeyInterface)this._elements.get(r)).getKey() > ((KeyInterface)this._elements.get(largest)).getKey()) {
            largest = r;
        }
        if (largest != i) {
            KeyInterface tmp = (KeyInterface)this._elements.get(largest);
            this._elements.set(largest, this._elements.get(i));
            this._elements.set(i, tmp);
            this.maxHeapify(largest);
        }
    }
}

