/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.core.util.PreconditionUtils;

public class GSVMCircle
implements Serializable {
    private static final long serialVersionUID = -3752536748200949347L;
    private final GSVMLicense[] licenses;
    private final long worldId;
    private final int size;
    private transient GSVMWorld world;

    GSVMCircle(GSVMWorld world, int size, int startId) {
        this.world = world;
        this.worldId = world.getId();
        this.size = size;
        PreconditionUtils.checkNotNegative(this.size);
        this.licenses = new GSVMLicense[this.size];
        int id = startId;
        for (int i = 0; i < this.size; ++i) {
            this.licenses[i] = new GSVMLicense(id++, i, world);
        }
    }

    public int getSize() {
        return this.size;
    }

    public GSVMWorld getWorld() {
        return this.world;
    }

    void refreshFieldBackReferences(GSVMWorld world) {
        Preconditions.checkArgument((world.getId() == this.worldId ? 1 : 0) != 0);
        this.world = world;
        for (GSVMLicense license : this.licenses) {
            license.refreshFieldBackReferences(this);
        }
    }

    public GSVMLicense[] getLicenses() {
        return Arrays.copyOf(this.licenses, this.licenses.length);
    }
}

