/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMCircle;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMNationalBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMRegionalBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class GSVMWorld
extends World {
    private static final long serialVersionUID = 1737956952755986936L;
    private static final String MODEL_NAME = "Global Synergy Value Model";
    private final Integer size;
    private final GSVMCircle nationalCircle;
    private final GSVMCircle regionalCircle;
    private transient ImmutableSet<GSVMLicense> licenseSet;

    public GSVMWorld(GSVMWorldSetup worldSetup, RNGSupplier rngSupplier) {
        super(MODEL_NAME);
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        this.size = worldSetup.drawSize(rng);
        this.nationalCircle = new GSVMCircle(this, this.size * 2, 0);
        this.regionalCircle = new GSVMCircle(this, this.size, this.size * 2);
        this.store();
    }

    public int getSize() {
        return this.size;
    }

    public GSVMCircle getNationalCircle() {
        return this.nationalCircle;
    }

    public GSVMCircle getRegionalCircle() {
        return this.regionalCircle;
    }

    public Collection<? extends Bidder<GSVMLicense>> restorePopulation(long populationId) {
        return super.restorePopulation(GSVMBidder.class, populationId);
    }

    public ImmutableSet<GSVMLicense> getLicenses() {
        if (this.licenseSet == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.add((Object[])this.nationalCircle.getLicenses());
            builder.add((Object[])this.regionalCircle.getLicenses());
            this.licenseSet = builder.build();
        }
        return this.licenseSet;
    }

    @Override
    public int getNumberOfGoods() {
        return this.nationalCircle.getLicenses().length + this.regionalCircle.getLicenses().length;
    }

    @Override
    public void refreshFieldBackReferences() {
        this.nationalCircle.refreshFieldBackReferences(this);
        this.regionalCircle.refreshFieldBackReferences(this);
    }

    public List<GSVMBidder> createPopulation(Collection<GSVMRegionalBidderSetup> regionalSetups, Collection<GSVMNationalBidderSetup> nationalSetups, RNGSupplier populationRNG) {
        long population = this.openNewPopulation();
        long currentId = 0L;
        ArrayList<GSVMBidder> bidders = new ArrayList<GSVMBidder>();
        if (regionalSetups != null) {
            int position = 0;
            for (GSVMRegionalBidderSetup setup : regionalSetups) {
                for (int i = 0; i < setup.getNumberOfBidders(); ++i) {
                    bidders.add(new GSVMBidder(setup, this, position++, currentId++, population, populationRNG));
                }
            }
        }
        if (nationalSetups != null) {
            for (GSVMBidderSetup gSVMBidderSetup : nationalSetups) {
                for (int i = 0; i < gSVMBidderSetup.getNumberOfBidders(); ++i) {
                    bidders.add(new GSVMBidder(gSVMBidderSetup, this, -1, currentId++, population, populationRNG));
                }
            }
        }
        Preconditions.checkArgument((bidders.size() > 0 ? 1 : 0) != 0, (Object)"At least one bidder setup with a strictly positive number of bidders is required to generate population");
        return bidders;
    }
}

