/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.model.mrvm.RandomOrderXORQFactory;
import org.spectrumauctions.sats.core.model.mrvm.SizeOrderedGenericFactory;
import org.spectrumauctions.sats.core.model.mrvm.SizeOrderedGenericPowersetFactory;
import org.spectrumauctions.sats.core.util.math.ContinuousPiecewiseLinearFunction;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public abstract class MRVMBidder
extends Bidder<MRVMLicense>
implements GenericValueBidder<MRVMGenericDefinition> {
    private static final long serialVersionUID = 8394009700504454313L;
    private transient MRVMWorld world;
    private final BigDecimal alpha;
    private final HashMap<Integer, BigDecimal> beta;
    private final HashMap<Integer, BigDecimal> zLow;
    private final HashMap<Integer, BigDecimal> zHigh;

    MRVMBidder(long id, long populationId, MRVMWorld world, MRVMBidderSetup setup, UniformDistributionRNG rng) {
        super(setup, populationId, id, world.getId());
        this.world = world;
        this.alpha = setup.drawAlpha(rng);
        this.beta = this.drawBeta(world, setup, rng);
        this.zLow = setup.drawZLow(this.beta, world, rng);
        this.zLow.forEach((key, value) -> Preconditions.checkArgument((value.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0));
        this.zHigh = setup.drawZHigh(this.beta, world, rng);
        this.assertRegionalValuesAssigned();
    }

    private HashMap<Integer, BigDecimal> drawBeta(MRVMWorld world, MRVMBidderSetup setup, UniformDistributionRNG rng) {
        HashMap<Integer, BigDecimal> tempBeta = new HashMap<Integer, BigDecimal>();
        for (MRVMRegionsMap.Region region : world.getRegionsMap().getRegions()) {
            tempBeta.put(region.getId(), setup.drawBeta(region, rng));
        }
        return tempBeta;
    }

    private void assertRegionalValuesAssigned() {
        for (MRVMRegionsMap.Region region : this.world.getRegionsMap().getRegions()) {
            Preconditions.checkArgument((this.getBeta(region) != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getzLow(region) != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getzHigh(region) != null ? 1 : 0) != 0);
        }
        if (this.beta.size() != this.world.getRegionsMap().getNumberOfRegions()) {
            throw new IllegalArgumentException("Defined beta for region which is not part of this world");
        }
    }

    public BigDecimal omegaFactor(MRVMRegionsMap.Region r, BigDecimal sv) {
        BigDecimal population = new BigDecimal(String.valueOf(r.getPopulation()));
        return sv.multiply(this.getBeta(r)).multiply(population);
    }

    public BigDecimal svFunction(MRVMRegionsMap.Region region, BigDecimal c) {
        Preconditions.checkArgument((c.compareTo(BigDecimal.ZERO) >= 0 && c.compareTo(this.world.getMaximumRegionalCapacity()) <= 0 ? 1 : 0) != 0, (Object)("c must be between 0 and the c for all licenses (=" + this.world.getMaximumRegionalCapacity().toString() + ") but is actually " + c.toString()));
        return this.svFunction(region).getY(c);
    }

    public ContinuousPiecewiseLinearFunction svFunction(MRVMRegionsMap.Region region) {
        int population = region.getPopulation();
        BigDecimal beta = this.getBeta(region);
        HashMap<BigDecimal, BigDecimal> cornerPoints = new HashMap<BigDecimal, BigDecimal>();
        cornerPoints.put(BigDecimal.ZERO, BigDecimal.ZERO);
        BigDecimal x1 = this.getzLow(region).multiply(BigDecimal.valueOf(population)).multiply(beta);
        BigDecimal y1 = BigDecimal.valueOf(0.27).multiply(this.alpha);
        cornerPoints.put(x1, y1);
        BigDecimal x2 = this.getzHigh(region).multiply(BigDecimal.valueOf(population)).multiply(beta);
        BigDecimal y2 = BigDecimal.valueOf(0.73).multiply(this.alpha);
        cornerPoints.put(x2, y2);
        BigDecimal x3 = this.world.getMaximumRegionalCapacity();
        BigDecimal y3 = this.alpha;
        cornerPoints.put(x3, y3);
        return new ContinuousPiecewiseLinearFunction(cornerPoints);
    }

    public abstract BigDecimal gammaFactor(MRVMRegionsMap.Region var1, Bundle<MRVMLicense> var2);

    public abstract Map<MRVMRegionsMap.Region, BigDecimal> gammaFactors(Bundle<MRVMLicense> var1);

    @Override
    public BigDecimal calculateValue(Bundle<MRVMLicense> bundle) {
        if (bundle.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalValue = BigDecimal.ZERO;
        Map<MRVMRegionsMap.Region, Bundle<MRVMLicense>> regionalBundles = MRVMWorld.getLicensesPerRegion(bundle);
        Map<MRVMRegionsMap.Region, BigDecimal> gammaFactors = this.gammaFactors(bundle);
        for (Map.Entry<MRVMRegionsMap.Region, Bundle<MRVMLicense>> regionalBundleEntry : regionalBundles.entrySet()) {
            BigDecimal c = MRVMWorld.c(regionalBundleEntry.getKey(), regionalBundleEntry.getValue());
            BigDecimal sv = this.svFunction(regionalBundleEntry.getKey(), c);
            BigDecimal regionalValue = this.omegaFactor(regionalBundleEntry.getKey(), sv);
            BigDecimal gammaFactor = gammaFactors.get(regionalBundleEntry.getKey());
            BigDecimal discountedRegionalValue = regionalValue.multiply(gammaFactor);
            totalValue = totalValue.add(discountedRegionalValue);
        }
        return totalValue;
    }

    @Override
    public BigDecimal calculateValue(Map<MRVMGenericDefinition, Integer> genericQuantities) {
        Bundle<MRVMLicense> bundle = new Bundle<MRVMLicense>();
        HashMap<MRVMGenericDefinition, Integer> addedQuantities = new HashMap<MRVMGenericDefinition, Integer>();
        for (MRVMRegionsMap.Region region : this.getWorld().getRegionsMap().getRegions()) {
            for (MRVMBand band : this.getWorld().getBands()) {
                addedQuantities.put(new MRVMGenericDefinition(band, region), 0);
            }
        }
        for (MRVMLicense license : this.getWorld().getLicenses()) {
            MRVMGenericDefinition def = new MRVMGenericDefinition(license.getBand(), license.getRegion());
            Integer requiredQuantity = genericQuantities.get(def);
            Integer addedQuantity = (Integer)addedQuantities.get(def);
            if (requiredQuantity == null || requiredQuantity <= addedQuantity) continue;
            bundle.add(license);
            addedQuantities.put(def, addedQuantity + 1);
        }
        return this.calculateValue(bundle);
    }

    @Override
    public MRVMWorld getWorld() {
        return this.world;
    }

    private void setWorld(MRVMWorld world) {
        this.world = world;
    }

    public BigDecimal getzLow(MRVMRegionsMap.Region region) {
        return this.zLow.get(region.getId());
    }

    public BigDecimal getzHigh(MRVMRegionsMap.Region region) {
        return this.zHigh.get(region.getId());
    }

    public BigDecimal getAlpha() {
        return this.alpha;
    }

    public BigDecimal getBeta(MRVMRegionsMap.Region region) {
        return this.beta.get(region.getId());
    }

    @Override
    public void refreshReference(World world) {
        if (!(world instanceof MRVMWorld)) {
            throw new IncompatibleWorldException("Wrong world class");
        }
        this.setWorld((MRVMWorld)world);
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, long seed) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR<MRVMLicense>(this.world.getLicenses(), new JavaUtilRNGSupplier(seed), this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR<MRVMLicense>(this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR<MRVMLicense>(this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(GenericSizeIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericSizeDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(XORQRandomOrderSimple.class)) {
            return (T)((BiddingLanguage)clazz.cast(RandomOrderXORQFactory.getXORQRandomOrderSimpleLang(this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.alpha == null ? 0 : this.alpha.hashCode());
        result = 31 * result + (this.beta == null ? 0 : this.beta.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MRVMBidder other = (MRVMBidder)obj;
        if (this.alpha == null ? other.alpha != null : !this.alpha.equals(other.alpha)) {
            return false;
        }
        return !(this.beta == null ? other.beta != null : !this.beta.equals(other.beta));
    }
}

