/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.spectrumauctions.sats.core.util.file.FileException;

public class FilePathUtils {
    public static File FOLDER = new File("sats_output");
    private final File folder = FOLDER;
    private static final String FILE_TYPE_BIDDER = ".bidder.json";
    private static final String FILE_TYPE_WORLD = ".world.json";
    private static final int BIDDER_ID_LENGTH = 5;
    private static final int POPULATION_ID_LENGTH = 5;
    private static final int WORLD_ID_LENGTH = 5;
    private static FilePathUtils instance = null;

    private FilePathUtils() {
        if (!this.folder.exists()) {
            this.folder.mkdir();
        }
    }

    public static FilePathUtils getInstance() {
        if (instance == null) {
            instance = new FilePathUtils();
        }
        return instance;
    }

    public File bidderFilePath(long worldId, long populationId, long bidderId) {
        String world = this.prependZeros(5, String.valueOf(worldId));
        String population = this.prependZeros(5, String.valueOf(populationId));
        String bidder = this.prependZeros(5, String.valueOf(bidderId));
        return this.bidderFilePath(world, population, bidder);
    }

    public File populationFolderPath(long worldId, long populationId) {
        String world = this.prependZeros(5, String.valueOf(worldId));
        String population = this.prependZeros(5, String.valueOf(populationId));
        return this.populationFolderPath(world, population);
    }

    public File worldFolderPath(long worldId) {
        String world = this.prependZeros(5, String.valueOf(worldId));
        return this.worldFolderPath(world);
    }

    public File worldFilePath(long worldId) {
        String world = this.prependZeros(5, String.valueOf(worldId));
        String fileName = world.concat(FILE_TYPE_WORLD);
        return new File(this.worldFolderPath(world).getAbsolutePath().concat("/").concat(fileName));
    }

    private File bidderFilePath(String worldId, String population, String bidderId) {
        String worldString = this.prependZeros(5, worldId);
        String populationString = this.prependZeros(5, population);
        String bidderString = this.prependZeros(5, bidderId);
        return new File(this.folder.getAbsolutePath() + "/" + worldString + "/" + populationString + "/" + bidderString + FILE_TYPE_BIDDER);
    }

    private File populationFolderPath(String worldId, String population) {
        String worldString = this.prependZeros(5, worldId);
        String populationString = this.prependZeros(5, population);
        return new File(this.folder.getAbsolutePath() + "/" + worldString + "/" + populationString);
    }

    private File worldFolderPath(String worldId) {
        String worldString = this.prependZeros(5, worldId);
        return new File(this.folder.getAbsolutePath() + "/" + worldString);
    }

    private String prependZeros(int stringLength, String number) {
        StringBuilder preZeros = new StringBuilder();
        for (int i = number.length(); i < 5; ++i) {
            preZeros.append('0');
        }
        return preZeros.toString() + number;
    }

    public Collection<Long> getPopulationIds(long worldId) {
        File worldFolder = this.worldFolderPath(worldId);
        File[] subFilesArray = worldFolder.listFiles();
        if (subFilesArray == null) {
            throw new FileException("Files could not be read. Check if Folder exists!");
        }
        List<File> subFiles = Arrays.asList(subFilesArray);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (File subFile : subFiles) {
            if (!subFile.isDirectory()) continue;
            try {
                ids.add(Long.valueOf(subFile.getName()));
            }
            catch (NumberFormatException e) {
                System.out.println("Folder which doesn't belong here was found and ignored");
            }
        }
        return ids;
    }

    public Collection<Long> getBidderIds(long worldId, long populationId) {
        File populationFolder = this.populationFolderPath(worldId, populationId);
        File[] subFilesArray = populationFolder.listFiles();
        if (subFilesArray == null) {
            throw new FileException("Files could not be read. Check if Folder exists!");
        }
        List<File> subFiles = Arrays.asList(subFilesArray);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (File subFile : subFiles) {
            if (subFile.isDirectory()) continue;
            String[] fileName = subFile.getName().split("\\.");
            String name = fileName[0];
            if (subFile.getName().contains(FILE_TYPE_BIDDER)) {
                try {
                    ids.add(Long.valueOf(name));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid Bidder File", e);
                }
            }
            System.out.println("File which is not a bidder file here was found and ignored " + subFile.getName());
        }
        return ids;
    }

    public String readFileToString(File file) {
        String fileContent;
        try {
            fileContent = FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            throw new FileException(e);
        }
        return fileContent;
    }

    public void writeStringToFile(File file, String content) {
        try {
            FileUtils.write((File)file, (CharSequence)content);
        }
        catch (IOException e) {
            throw new FileException(e);
        }
    }
}

