/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.file.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.jgrapht.graph.UnmodifiableUndirectedGraph;
import org.spectrumauctions.sats.core.util.file.FileException;
import org.spectrumauctions.sats.core.util.file.gson.UndirectedGraphAdapter;

public class GsonWrapper {
    private static final String IMPLEMENTATION_FIELD = "implementation";
    private static final boolean PRETTY_JSON = true;
    private static GsonWrapper INSTANCE = null;
    private Gson gson;

    private GsonWrapper() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(UnmodifiableUndirectedGraph.class, (Object)new UndirectedGraphAdapter());
        builder.disableHtmlEscaping();
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public static GsonWrapper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GsonWrapper();
        }
        return INSTANCE;
    }

    public Gson getGson() {
        return this.gson;
    }

    public <T> T fromJson(Class<T> type, String json) {
        Object object = this.gson.fromJson(json, type);
        return (T)object;
    }

    public String toJson(Object object) {
        JsonElement jsonElement = this.gson.toJsonTree(object);
        jsonElement.getAsJsonObject().addProperty(IMPLEMENTATION_FIELD, object.getClass().getName());
        return this.gson.toJson(jsonElement);
    }

    public Class<?> readClass(String json) {
        String typeString = this.readField(IMPLEMENTATION_FIELD, json);
        try {
            return Class.forName(typeString);
        }
        catch (ClassNotFoundException e) {
            throw new FileException("Type Unknown", e);
        }
    }

    public String readField(String key, String json) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        return jsonObject.get(key).getAsString();
    }
}

