/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.file.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.graph.UnmodifiableUndirectedGraph;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;

public class UndirectedGraphAdapter
implements JsonSerializer<UnmodifiableUndirectedGraph<MRVMRegionsMap.Region, DefaultEdge>>,
JsonDeserializer<UnmodifiableUndirectedGraph<MRVMRegionsMap.Region, DefaultEdge>> {
    public JsonElement serialize(UnmodifiableUndirectedGraph<MRVMRegionsMap.Region, DefaultEdge> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray result = new JsonArray();
        for (MRVMRegionsMap.Region region : src.vertexSet()) {
            SerializedRegion r = new SerializedRegion(region);
            for (MRVMRegionsMap.Region neighborCandidate : src.vertexSet()) {
                if (!src.containsEdge((Object)region, (Object)neighborCandidate)) continue;
                r.addAdjacentRegion(neighborCandidate.getId());
            }
            JsonElement serializedRegion = context.serialize((Object)r);
            result.add(serializedRegion);
        }
        return result;
    }

    public UnmodifiableUndirectedGraph<MRVMRegionsMap.Region, DefaultEdge> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonArray jsonArray = json.getAsJsonArray();
        HashSet<SerializedRegion> serializedRegions = new HashSet<SerializedRegion>();
        HashMap<Integer, MRVMRegionsMap.Region> regionsById = new HashMap<Integer, MRVMRegionsMap.Region>();
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement regionElement = jsonArray.get(i);
            SerializedRegion r = (SerializedRegion)context.deserialize(regionElement, SerializedRegion.class);
            serializedRegions.add(r);
            regionsById.put(r.getNode().getId(), r.getNode());
            graph.addVertex((Object)r.getNode());
        }
        for (SerializedRegion serializedRegion : serializedRegions) {
            SortedSet<Integer> neighbors = serializedRegion.getNeighbors();
            for (Integer neighborId : neighbors) {
                graph.addEdge((Object)serializedRegion.getNode(), regionsById.get(neighborId));
            }
        }
        return new UnmodifiableUndirectedGraph((UndirectedGraph)graph);
    }

    public static class SerializedRegion {
        private final MRVMRegionsMap.Region node;
        private final SortedSet<Integer> neighbors;

        public SerializedRegion(MRVMRegionsMap.Region node) {
            this.node = node;
            this.neighbors = new TreeSet<Integer>();
        }

        public void addAdjacentRegion(int id) {
            this.neighbors.add(id);
        }

        public MRVMRegionsMap.Region getNode() {
            return this.node;
        }

        public SortedSet<Integer> getNeighbors() {
            return this.neighbors;
        }
    }
}

