/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.instancehandling;

import java.util.Collection;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.util.instancehandling.InstanceHandler;
import org.spectrumauctions.sats.core.util.random.UniformJavaUtilRandomWrapper;

public class InMemoryInstanceHandler
extends InstanceHandler {
    private static InMemoryInstanceHandler instance;
    private static final String UNSUPPORTED_OPERATION_MESSAGE = "The selected InstanceHandler does not support this method. Use another Instance Handler instead.";
    private long nextWorldId;
    private long nextPopulationId;

    private InMemoryInstanceHandler() {
        UniformJavaUtilRandomWrapper rng = new UniformJavaUtilRandomWrapper();
        this.nextPopulationId = Integer.MAX_VALUE + (long)rng.nextInt();
        this.nextWorldId = Integer.MAX_VALUE + (long)rng.nextInt();
    }

    public static InMemoryInstanceHandler getInstance() {
        if (instance == null) {
            instance = new InMemoryInstanceHandler();
        }
        return instance;
    }

    @Override
    public void writeWorld(World world) {
    }

    @Override
    public void writeBidder(Bidder<?> bidder) {
    }

    @Override
    public Collection<Long> getPopulationIds(long worldId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public <T extends Bidder<?>> T readBidder(Class<T> type, World world, long populationId, long bidderId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public <T extends Bidder<?>> Collection<T> readPopulation(Class<T> type, World world, long populationId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public <T extends Bidder<?>> T readBidderWithUnknownType(Class<T> bidderSuperType, World world, long populationId, long bidderId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public <T extends Bidder<?>> Collection<T> readPopulationWithUnknownTypes(Class<T> bidderSuperType, World world, long populationId) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public long getNextWorldId() {
        return this.nextWorldId++;
    }

    @Override
    public long getNextPopulationId(long worldId) {
        return this.nextPopulationId++;
    }

    @Override
    public <T extends World> T readWorld(Class<T> type, long world) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }
}

