/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.math;

import com.google.common.collect.ImmutableSortedMap;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.spectrumauctions.sats.core.util.math.Function;
import org.spectrumauctions.sats.core.util.math.LinearFunction;
import org.spectrumauctions.sats.core.util.math.NotDifferentiableException;
import org.spectrumauctions.sats.core.util.math.OutOfDomainException;

public final class ContinuousPiecewiseLinearFunction
implements Function {
    private final SortedMap<BigDecimal, LinearFunction> linearFunctions;
    private final BigDecimal lowestX;

    public ContinuousPiecewiseLinearFunction(Map<BigDecimal, BigDecimal> cornerPoints) {
        TreeMap<BigDecimal, BigDecimal> sortedCornerPoints = new TreeMap<BigDecimal, BigDecimal>(cornerPoints);
        ImmutableSortedMap.Builder linearFunctionsBuilder = ImmutableSortedMap.naturalOrder();
        Iterator entryIterator = sortedCornerPoints.entrySet().iterator();
        Map.Entry lowerEntry = entryIterator.next();
        this.lowestX = (BigDecimal)lowerEntry.getKey();
        while (entryIterator.hasNext()) {
            Map.Entry upperEntry = entryIterator.next();
            if (((BigDecimal)lowerEntry.getKey()).compareTo((BigDecimal)upperEntry.getKey()) == 0) continue;
            LinearFunction linearFunction = new LinearFunction((BigDecimal)lowerEntry.getKey(), (BigDecimal)lowerEntry.getValue(), (BigDecimal)upperEntry.getKey(), (BigDecimal)upperEntry.getValue());
            linearFunctionsBuilder.put(upperEntry.getKey(), (Object)linearFunction);
            lowerEntry = upperEntry;
        }
        this.linearFunctions = linearFunctionsBuilder.build();
    }

    public List<AbstractMap.SimpleImmutableEntry<BigDecimal, BigDecimal>> getCornerPoints() {
        ArrayList<AbstractMap.SimpleImmutableEntry<BigDecimal, BigDecimal>> result = new ArrayList<AbstractMap.SimpleImmutableEntry<BigDecimal, BigDecimal>>();
        BigDecimal firstY = this.getY(this.lowestX);
        result.add(new AbstractMap.SimpleImmutableEntry<BigDecimal, BigDecimal>(this.lowestX, firstY));
        for (BigDecimal functionUpperX : this.linearFunctions.keySet()) {
            BigDecimal y = this.getY(functionUpperX);
            result.add(new AbstractMap.SimpleImmutableEntry<BigDecimal, BigDecimal>(functionUpperX, y));
        }
        return result;
    }

    @Override
    public BigDecimal getY(BigDecimal x) {
        try {
            return this.functionAt(x).getY(x);
        }
        catch (NotDifferentiableException e) {
            return e.getCornerPointY();
        }
    }

    public LinearFunction functionAt(BigDecimal x) throws NotDifferentiableException {
        if (x.compareTo(this.lowestX) < 0) {
            throw new OutOfDomainException("X is smaller than domain allows");
        }
        if (x.compareTo(this.lowestX) == 0) {
            try {
                BigDecimal firstKey = this.linearFunctions.firstKey();
                throw new NotDifferentiableException(null, (LinearFunction)this.linearFunctions.get(firstKey), x);
            }
            catch (NoSuchElementException e) {
                System.out.println("break");
            }
        }
        Iterator<Map.Entry<BigDecimal, LinearFunction>> functionEntries = this.linearFunctions.entrySet().iterator();
        while (functionEntries.hasNext()) {
            Map.Entry<BigDecimal, LinearFunction> functionEntry = functionEntries.next();
            if (x.compareTo(functionEntry.getKey()) <= 0) {
                LinearFunction higherAdjacentFunction = null;
                if (functionEntries.hasNext()) {
                    higherAdjacentFunction = functionEntries.next().getValue();
                }
                throw new NotDifferentiableException(functionEntry.getValue(), higherAdjacentFunction, x);
            }
            if (x.compareTo(functionEntry.getKey()) >= 0) continue;
            return functionEntry.getValue();
        }
        throw new OutOfDomainException("X is bigger than domain allows");
    }
}

