/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.spectrumauctions.sats.core.util.math.Function;

public final class LinearFunction
implements Function {
    private static int SCALE = 10;
    private final BigDecimal slope;
    private final BigDecimal yIntercept;

    public LinearFunction(BigDecimal x1, BigDecimal y1, BigDecimal x2, BigDecimal y2) {
        BigDecimal deltaX = x1.subtract(x2);
        BigDecimal deltaY = y1.subtract(y2);
        this.slope = deltaY.divide(deltaX, SCALE, RoundingMode.CEILING);
        this.yIntercept = y1.subtract(x1.multiply(this.slope));
    }

    public LinearFunction(BigDecimal x, BigDecimal y, BigDecimal slope) {
        this.slope = slope;
        this.yIntercept = y.subtract(x.multiply(slope));
    }

    public LinearFunction(BigDecimal slope, BigDecimal yIntercept) {
        this.slope = slope;
        this.yIntercept = yIntercept;
    }

    @Override
    public BigDecimal getY(BigDecimal x) {
        return x.multiply(this.slope).add(this.yIntercept);
    }

    public boolean isValid(BigDecimal x, BigDecimal y) {
        return this.getY(x).compareTo(y) == 0;
    }

    public BigDecimal getSlope() {
        return this.slope;
    }

    public BigDecimal getyIntercept() {
        return this.yIntercept;
    }

    public static int getSCALE() {
        return SCALE;
    }

    public static void setSCALE(int scale) {
        SCALE = scale;
    }
}

