/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.random;

import java.util.Random;
import org.spectrumauctions.sats.core.util.random.GaussianDistributionRNG;
import org.spectrumauctions.sats.core.util.random.GaussianJavaUtilRandomWrapper;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;
import org.spectrumauctions.sats.core.util.random.UniformJavaUtilRandomWrapper;

public class JavaUtilRNGSupplier
implements RNGSupplier {
    private static final long serialVersionUID = -8797044645698919966L;
    private final Random seedGenerator;
    private final long initSeed;

    public JavaUtilRNGSupplier() {
        this(System.currentTimeMillis());
    }

    public JavaUtilRNGSupplier(long initSeed) {
        this.seedGenerator = new Random(initSeed);
        this.initSeed = initSeed;
    }

    @Override
    public UniformDistributionRNG getUniformDistributionRNG(long seed) {
        return new UniformJavaUtilRandomWrapper(seed);
    }

    @Override
    public UniformDistributionRNG getUniformDistributionRNG() {
        return new UniformJavaUtilRandomWrapper(this.seedGenerator.nextLong());
    }

    public long getInitSeed() {
        return this.initSeed;
    }

    @Override
    public GaussianDistributionRNG getGaussianDistributionRNG() {
        return new GaussianJavaUtilRandomWrapper(this.seedGenerator.nextLong());
    }

    @Override
    public GaussianDistributionRNG getGaussianDistributionRNG(long seed) {
        return new GaussianJavaUtilRandomWrapper(seed);
    }
}

