/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.api;

import java.io.File;
import java.io.IOException;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.ModelCreator;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidderSetup;
import org.spectrumauctions.sats.core.model.srvm.SingleRegionModel;

public class SRVMModelCreator
extends ModelCreator {
    private final int numSmallBidders;
    private final int numHighFrequencyBidders;
    private final int numPrimaryBidders;
    private final int numSecondaryBidders;

    protected SRVMModelCreator(Builder builder) {
        super(builder);
        this.numSmallBidders = builder.numSmallBidders;
        this.numHighFrequencyBidders = builder.numHighFrequencyBidders;
        this.numPrimaryBidders = builder.numPrimaryBidders;
        this.numSecondaryBidders = builder.numSecondaryBidders;
    }

    @Override
    public PathResult generateResult(File outputFolder) throws UnsupportedBiddingLanguageException, IOException, IllegalConfigException {
        SingleRegionModel model = new SingleRegionModel();
        model.setNumberOfHighFrequencyBidders(this.numHighFrequencyBidders);
        model.setNumberOfPrimaryBidders(this.numPrimaryBidders);
        model.setNumberOfSecondaryBidders(this.numSecondaryBidders);
        model.setNumberOfSmallBidders(this.numSmallBidders);
        return this.appendTopLevelParamsAndSolve(model, outputFolder);
    }

    public static class Builder
    extends ModelCreator.Builder {
        public int numSecondaryBidders;
        public int numPrimaryBidders;
        public int numHighFrequencyBidders;
        public int numSmallBidders = new SRVMBidderSetup.SmallBidderBuilder().getNumberOfBidders();

        public Builder() {
            this.numPrimaryBidders = new SRVMBidderSetup.PrimaryBidderBuilder().getNumberOfBidders();
            this.numSecondaryBidders = new SRVMBidderSetup.SecondaryBidderBuilder().getNumberOfBidders();
            this.numHighFrequencyBidders = new SRVMBidderSetup.HighFrequenceBidderBuilder().getNumberOfBidders();
        }

        @Override
        public SRVMModelCreator build() {
            return new SRVMModelCreator(this);
        }

        public void setNumSecondaryBidders(int numSecondaryBidders) {
            this.numSecondaryBidders = numSecondaryBidders;
        }

        public void setNumPrimaryBidders(int numPrimaryBidders) {
            this.numPrimaryBidders = numPrimaryBidders;
        }

        public void setNumHighFrequencyBidders(int numHighFrequencyBidders) {
            this.numHighFrequencyBidders = numHighFrequencyBidders;
        }

        public void setNumSmallBidders(int numSmallBidders) {
            this.numSmallBidders = numSmallBidders;
        }

        public int getNumSecondaryBidders() {
            return this.numSecondaryBidders;
        }

        public int getNumPrimaryBidders() {
            return this.numPrimaryBidders;
        }

        public int getNumHighFrequencyBidders() {
            return this.numHighFrequencyBidders;
        }

        public int getNumSmallBidders() {
            return this.numSmallBidders;
        }
    }
}

