/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.XORQtoXOR;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;

public final class GenericValue<T extends GenericDefinition> {
    private final int totalQuantity;
    private final ImmutableMap<T, Integer> quantities;
    private final BigDecimal value;
    private final transient int size;

    private GenericValue(Builder<T> builder) {
        this.quantities = ImmutableMap.copyOf((Map)((Builder)builder).quantities);
        int totalQuantity = 0;
        for (Integer quantity : this.quantities.values()) {
            totalQuantity += quantity.intValue();
        }
        this.totalQuantity = totalQuantity;
        this.value = ((Builder)builder).value;
        this.size = this.calcSize();
    }

    public int getQuantity(T definition) {
        Integer result = (Integer)this.quantities.get(definition);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Bundle<?> anyConsistentBundle() {
        Bundle bundle = new Bundle();
        for (Map.Entry entry : this.quantities.entrySet()) {
            ArrayList<? extends Good> objects = new ArrayList<Good>(((GenericDefinition)entry.getKey()).allLicenses());
            bundle.addAll(objects.subList(0, (Integer)entry.getValue()));
        }
        return bundle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericValue that = (GenericValue)o;
        if (this.totalQuantity != that.totalQuantity) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        return (this.quantities != null ? this.quantities.equals(that.quantities) : that.quantities == null) && (this.value != null ? this.value.equals(that.value) : that.value == null);
    }

    public int hashCode() {
        int result = this.totalQuantity;
        result = 31 * result + (this.quantities != null ? this.quantities.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + this.size;
        return result;
    }

    public int getTotalQuantity() {
        return this.totalQuantity;
    }

    public ImmutableMap<T, Integer> getQuantities() {
        return this.quantities;
    }

    private int calcSize() {
        int size = 0;
        UnmodifiableIterator unmodifiableIterator = this.quantities.values().iterator();
        while (unmodifiableIterator.hasNext()) {
            int quantity = (Integer)unmodifiableIterator.next();
            size += quantity;
        }
        return size;
    }

    public Iterator<XORValue<?>> plainXorIterator() {
        return new Iterator<XORValue<?>>(){
            private XORQtoXOR<Good> quantitiesIter;
            {
                this.quantitiesIter = new XORQtoXOR((Map<? extends GenericDefinition, Integer>)GenericValue.this.quantities);
            }

            @Override
            public boolean hasNext() {
                return this.quantitiesIter.hasNext();
            }

            @Override
            public XORValue<?> next() {
                Object bundle = this.quantitiesIter.next();
                return new XORValue(bundle, GenericValue.this.value);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (GenericDefinition property : this.quantities.keySet()) {
            res.append(property.toString()).append(":").append(this.quantities.get((Object)property)).append(" ");
        }
        res.append("\t").append(this.value);
        return res.toString();
    }

    public static class Builder<T extends GenericDefinition> {
        private BigDecimal value;
        private GenericValueBidder<T> bidder;
        private Map<T, Integer> quantities = new HashMap<T, Integer>();

        public Builder(BigDecimal value) {
            this.value = value;
        }

        public Builder(GenericValueBidder<T> bidder) {
            this.bidder = bidder;
        }

        public void putQuantity(T def, int quantity) {
            Preconditions.checkNotNull(def);
            Preconditions.checkNotNull((Object)quantity);
            Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0);
            this.quantities.put(def, quantity);
        }

        public GenericValue<T> build() {
            if (this.value == null) {
                this.value = this.bidder.calculateValue(this.quantities);
            }
            return new GenericValue(this);
        }
    }
}

