/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericLang;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericSetsPickN;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public abstract class GenericPowerset<T extends GenericDefinition>
implements GenericLang<T> {
    final Map<T, Integer> maxQuantities;
    final int maxBundleSize;

    protected GenericPowerset(List<T> genericDefinitions) throws UnsupportedBiddingLanguageException {
        LinkedHashMap<GenericDefinition, Integer> orderedMap = new LinkedHashMap<GenericDefinition, Integer>();
        int quantitySum = 0;
        for (GenericDefinition def : genericDefinitions) {
            quantitySum += def.numberOfLicenses();
            orderedMap.put(def, def.numberOfLicenses());
        }
        this.maxQuantities = Collections.unmodifiableMap(orderedMap);
        this.maxBundleSize = quantitySum;
        this.isFeasibleSize(this.maxQuantities, this.maxBundleSize);
    }

    GenericPowerset(Map<T, Integer> maxQuantities, int maxBundleSize) throws UnsupportedBiddingLanguageException {
        this.isFeasibleSize(maxQuantities, maxBundleSize);
        this.maxQuantities = Collections.unmodifiableMap(new LinkedHashMap<T, Integer>(maxQuantities));
        this.maxBundleSize = maxBundleSize;
    }

    protected abstract void isFeasibleSize(Map<T, Integer> var1, int var2) throws UnsupportedBiddingLanguageException;

    protected abstract GenericValueBidder<T> getGenericBidder();

    abstract class PowersetIterator
    implements Iterator<GenericValue<T>> {
        int bundleSize;
        GenericSetsPickN<T> pickN;

        PowersetIterator() {
        }

        @Override
        public GenericValue<T> next() {
            if (!this.pickN.hasNext()) {
                this.intiPickN();
            }
            Object quantities = this.pickN.next();
            GenericValue.Builder<GenericDefinition> genValBuilder = new GenericValue.Builder<GenericDefinition>(GenericPowerset.this.getGenericBidder());
            for (Map.Entry entry : quantities.entrySet()) {
                genValBuilder.putQuantity((GenericDefinition)entry.getKey(), (Integer)entry.getValue());
            }
            return genValBuilder.build();
        }

        abstract void intiPickN();
    }
}

