/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.BidderSetup;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.util.instancehandling.InstanceHandler;

public abstract class Bidder<G extends Good>
implements Serializable {
    private static final long serialVersionUID = 3424512863538320455L;
    private final String setupType;
    private final long population;
    private final long id;
    private final long worldId;

    protected Bidder(BidderSetup setup, long population, long id, long worldId) {
        this.setupType = setup.getSetupName();
        this.id = id;
        this.population = population;
        this.worldId = worldId;
    }

    public long getId() {
        return this.id;
    }

    public String getSetupType() {
        return this.setupType;
    }

    @Deprecated
    public double getValue(Bundle<G> bundle) {
        if (bundle.getWorld().equals(this.getWorld())) {
            throw new IncompatibleWorldException("Bundle not from the same world as the bidder");
        }
        return this.calculateValue(bundle).doubleValue();
    }

    public abstract BigDecimal calculateValue(Bundle<G> var1);

    public <T extends BiddingLanguage> T getValueFunction(Class<T> type) throws UnsupportedBiddingLanguageException {
        return this.getValueFunction(type, new Date().getTime());
    }

    public abstract <T extends BiddingLanguage> T getValueFunction(Class<T> var1, long var2) throws UnsupportedBiddingLanguageException;

    public long getPopulation() {
        return this.population;
    }

    public abstract World getWorld();

    protected void store() {
        InstanceHandler.getDefaultHandler().writeBidder(this);
    }

    public abstract void refreshReference(World var1);

    public long getWorldId() {
        return this.worldId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.setupType == null ? 0 : this.setupType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bidder other = (Bidder)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.setupType == null ? other.setupType != null : !this.setupType.equals(other.setupType));
    }
}

