/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.UnequalWorldsException;
import org.spectrumauctions.sats.core.model.World;

public class Bundle<T extends Good>
extends TreeSet<T> {
    private static final long serialVersionUID = -821067248569898586L;
    protected World world;

    public Bundle(Collection<T> allGoods) {
        this();
        this.addAll(allGoods);
    }

    @SafeVarargs
    public Bundle(T ... goods) {
        this((Collection<T>)Arrays.asList(goods));
    }

    public Bundle() {
        super(new Good.IdComparator());
    }

    public String itemIds(String deliminator) {
        StringBuilder ids = new StringBuilder();
        boolean first = true;
        for (Good good : this) {
            if (!first) {
                ids.append(deliminator);
            }
            first = false;
            ids.append(String.valueOf(good.getId()));
        }
        return ids.toString();
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Good good : this) {
            hashCode = hashCode * 32 + good.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean add(T obj) {
        if (obj == null) {
            return false;
        }
        if (this.world == null) {
            this.world = ((Good)obj).getWorld();
        } else if (!this.world.equals(((Good)obj).getWorld())) {
            throw new UnequalWorldsException();
        }
        return super.add(obj);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (Good good : c) {
            result |= this.add((T)good);
        }
        return result;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bundle)) {
            return false;
        }
        Bundle otherBundle = (Bundle)o;
        return otherBundle.size() == this.size() && this.containsAll(otherBundle);
    }
}

