/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.util.instancehandling.InstanceHandler;

public abstract class World
implements Serializable {
    private static final long serialVersionUID = -2556437180180680834L;
    protected final String modelName;
    protected final long id = InstanceHandler.getDefaultHandler().getNextWorldId();

    public World(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public long getId() {
        return this.id;
    }

    public abstract int getNumberOfGoods();

    public abstract Set<? extends Good> getLicenses();

    protected void store() {
        InstanceHandler.getDefaultHandler().writeWorld(this);
    }

    protected long openNewPopulation() {
        return InstanceHandler.getDefaultHandler().getNextPopulationId(this.getId());
    }

    public abstract Collection<? extends Bidder<?>> restorePopulation(long var1);

    public <T extends Bidder<?>> Collection<T> restorePopulation(Class<T> type, long populationId, InstanceHandler storageHandler) {
        return storageHandler.readPopulationWithUnknownTypes(type, this, populationId);
    }

    protected <T extends Bidder<?>> Collection<T> restorePopulation(Class<T> type, long populationId) {
        return this.restorePopulation(type, populationId, InstanceHandler.getDefaultHandler());
    }

    public abstract void refreshFieldBackReferences();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modelName == null ? 0 : this.modelName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        World other = (World)obj;
        return !(this.modelName == null ? other.modelName != null : !this.modelName.equals(other.modelName));
    }
}

