/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.bvm.BMBand;
import org.spectrumauctions.sats.core.model.bvm.BMBidderSetup;
import org.spectrumauctions.sats.core.model.bvm.BMLicense;
import org.spectrumauctions.sats.core.model.bvm.BMWorld;
import org.spectrumauctions.sats.core.model.bvm.RandomOrderXORQFactory;
import org.spectrumauctions.sats.core.model.bvm.SizeOrderedGenericFactory;
import org.spectrumauctions.sats.core.model.bvm.SizeOrderedGenericPowersetFactory;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class BMBidder
extends Bidder<BMLicense>
implements GenericValueBidder<BMBand> {
    private static final Logger logger = LogManager.getLogger(BMBidder.class);
    private static final long serialVersionUID = 3132260871321701148L;
    private transient BMWorld world;
    private final HashMap<String, Map<Integer, BigDecimal>> synergyFactors;
    private final HashMap<String, BigDecimal> baseValues;
    private final HashMap<String, Integer> positiveValueThreshold;

    public BMBidder(long population, int bidderId, BMWorld world, BMBidderSetup setup, UniformDistributionRNG rng) {
        super(setup, population, bidderId, world.getId());
        this.world = world;
        HashMap<String, Map<Integer, BigDecimal>> synergyFactors = new HashMap<String, Map<Integer, BigDecimal>>();
        HashMap<String, BigDecimal> baseValues = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> positiveValueThreshold = new HashMap<String, Integer>();
        for (BMBand band : world.getBands()) {
            synergyFactors.put(band.getName(), setup.drawSynergyFactors(band, rng));
            baseValues.put(band.getName(), setup.drawBaseValue(band, rng));
            positiveValueThreshold.put(band.getName(), setup.drawPositiveValueThreshold(band, rng));
        }
        this.synergyFactors = synergyFactors;
        this.baseValues = baseValues;
        this.positiveValueThreshold = positiveValueThreshold;
        this.store();
    }

    @Override
    public BigDecimal calculateValue(Bundle<BMLicense> bundle) {
        if (bundle.isEmpty()) {
            return BigDecimal.ZERO;
        }
        Preconditions.checkArgument((boolean)bundle.getWorld().equals(this.getWorld()), (Object)"Bundle not from same world as this bidder");
        HashMap<BMBand, Integer> quantities = new HashMap<BMBand, Integer>();
        for (BMBand band : this.getWorld().getBands()) {
            quantities.put(band, 0);
        }
        for (BMLicense license : bundle) {
            Integer currentValue = (Integer)quantities.get(license.getBand());
            if (currentValue == null) {
                logger.error("ITEM WITH OUTSIDE-WORLD BAND!");
                continue;
            }
            if (currentValue >= this.positiveValueThreshold.get(license.getBand().getName())) continue;
            quantities.put(license.getBand(), currentValue + 1);
        }
        return this.calculateValue((Map<BMBand, Integer>)quantities);
    }

    public BigDecimal synergyFactor(BMBand band, int quantity) {
        Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0);
        if (quantity == 1) {
            return BigDecimal.ONE;
        }
        if (quantity == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal synFactor = this.synergyFactors.get(band.getName()).get(quantity);
        if (synFactor != null) {
            return synFactor;
        }
        return this.synergyFactor(band, quantity - 1);
    }

    public BigDecimal getBaseValue(BMBand band) {
        return this.baseValues.get(band.getName());
    }

    public int highestSynergyQuantity(BMBand band) {
        if (this.synergyFactors.get(band.getName()) == null) {
            return 1;
        }
        if (this.synergyFactors.get(band.getName()) == null || this.synergyFactors.get(band.getName()).isEmpty()) {
            return 1;
        }
        Integer result = Collections.max(this.synergyFactors.get(band.getName()).keySet());
        if (result == null || result < 1) {
            return 1;
        }
        return result;
    }

    @Override
    public BMWorld getWorld() {
        return this.world;
    }

    private void setWorld(BMWorld world) {
        if (this.getWorldId() != world.getId()) {
            throw new IncompatibleWorldException("The stored worldId does not represent the passed world reference");
        }
        this.world = world;
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, long seed) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR<BMLicense>(this.world.getLicenses(), new JavaUtilRNGSupplier(seed), this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR<BMLicense>(this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR<BMLicense>(this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(GenericSizeIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericSizeDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(XORQRandomOrderSimple.class)) {
            return (T)((BiddingLanguage)clazz.cast(RandomOrderXORQFactory.getXORQRandomOrderSimpleLang(this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public void refreshReference(World world) {
        if (!(world instanceof BMWorld)) {
            throw new IncompatibleWorldException("Wrong world class");
        }
        this.setWorld((BMWorld)world);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.baseValues == null ? 0 : this.baseValues.hashCode());
        result = 31 * result + (this.positiveValueThreshold == null ? 0 : this.positiveValueThreshold.hashCode());
        result = 31 * result + (this.synergyFactors == null ? 0 : this.synergyFactors.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BMBidder other = (BMBidder)obj;
        if (this.baseValues == null ? other.baseValues != null : !this.baseValues.equals(other.baseValues)) {
            return false;
        }
        if (this.positiveValueThreshold == null ? other.positiveValueThreshold != null : !this.positiveValueThreshold.equals(other.positiveValueThreshold)) {
            return false;
        }
        return !(this.synergyFactors == null ? other.synergyFactors != null : !this.synergyFactors.equals(other.synergyFactors));
    }

    @Override
    public BigDecimal calculateValue(Map<BMBand, Integer> genericQuantities) {
        for (Map.Entry<BMBand, Integer> entry : genericQuantities.entrySet()) {
            Preconditions.checkArgument((boolean)entry.getKey().getWorld().equals(this.getWorld()), (Object)("Band is not from this world" + entry.getKey().getName()));
            Preconditions.checkArgument((entry.getValue() >= 0 ? 1 : 0) != 0, (Object)("Quantity must not be negative. Band:" + entry.getKey().getName() + "\t Licenses:" + entry.getValue()));
            Preconditions.checkArgument((entry.getValue() <= entry.getKey().getNumberOfLicenses() ? 1 : 0) != 0, (Object)("Specified too many licenses for this band" + entry.getKey().getName() + "\t Licenses:" + entry.getValue()));
        }
        BigDecimal value = BigDecimal.ZERO;
        for (Map.Entry<BMBand, Integer> entry : genericQuantities.entrySet()) {
            BigDecimal synergyFactor;
            int synergyQuantitiyLimit = this.highestSynergyQuantity(entry.getKey());
            BigDecimal baseValue = this.getBaseValue(entry.getKey());
            if (entry.getValue() > synergyQuantitiyLimit) {
                synergyFactor = this.synergyFactor(entry.getKey(), synergyQuantitiyLimit);
                value = value.add(new BigDecimal(synergyQuantitiyLimit).multiply(synergyFactor).multiply(baseValue));
                value = value.add(baseValue.multiply(new BigDecimal(entry.getValue() - synergyQuantitiyLimit)));
                continue;
            }
            synergyFactor = this.synergyFactor(entry.getKey(), entry.getValue());
            value = value.add(new BigDecimal(entry.getValue()).multiply(synergyFactor).multiply(baseValue));
        }
        return value;
    }
}

