/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.bvm.BMBand;
import org.spectrumauctions.sats.core.model.bvm.BMWorld;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class BMLicense
extends Good {
    private static final long serialVersionUID = -597579273878128574L;
    private transient BMBand band;
    private final String bandName;
    private transient BMWorld world;

    BMLicense(int id, BMBand band, RNGSupplier rngSupplier) {
        super(id, band.getWorldId());
        this.band = band;
        this.bandName = band.getName();
        this.world = band.getWorld();
    }

    public BMBand getBand() {
        return this.band;
    }

    private void setWorld(BMWorld world) {
        if (this.getWorldId() != world.getId()) {
            throw new IncompatibleWorldException("The stored worldId does not represent the passed world reference");
        }
        this.world = world;
    }

    private void setBand(BMBand band) {
        if (!this.bandName.equals(band.getName()) || band.getWorldId() != this.getWorldId()) {
            throw new IncompatibleWorldException("The stored worldId / bandName do not represent the passed band reference");
        }
        this.band = band;
    }

    public void refreshFieldBackReferences(BMBand bmBand) {
        this.setWorld(bmBand.getWorld());
        this.setBand(bmBand);
    }

    @Override
    public BMWorld getWorld() {
        return this.world;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bandName == null ? 0 : this.bandName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BMLicense other = (BMLicense)obj;
        return !(this.bandName == null ? other.bandName != null : !this.bandName.equals(other.bandName));
    }
}

