/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm.mbvm;

import java.math.BigDecimal;
import java.util.HashMap;
import org.spectrumauctions.sats.core.model.bvm.BMBand;
import org.spectrumauctions.sats.core.model.bvm.BMBidderSetup;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class MBVMBidderSetup
extends BMBidderSetup {
    public static final String DEFAULT_SETUP_NAME = "DEFAULT_MULTIBAND_VALUE_MODEL_BIDDER_SETUP";

    private MBVMBidderSetup(MBVMBidderSetupBuilder builder) {
        super(builder);
    }

    @Override
    public Integer drawPositiveValueThreshold(BMBand band, UniformDistributionRNG rng) {
        return band.getNumberOfLicenses();
    }

    public static MBVMBidderSetup getDefaultSetup(int numberOfBidders) {
        return new MBVMBidderSetupBuilder(DEFAULT_SETUP_NAME, numberOfBidders).build();
    }

    public static final class MBVMBidderSetupBuilder
    extends BMBidderSetup.BMBidderSetupBuilder {
        public MBVMBidderSetupBuilder(String setupName, int numberOfBidders) {
            super(setupName, numberOfBidders);
            this.putBaseValueInterval("A", new DoubleInterval(100.0, 300.0));
            this.putBaseValueInterval("B", new DoubleInterval(50.0, 200.0));
            this.putBaseValueInterval("C", new DoubleInterval(50.0, 200.0));
            this.putBaseValueInterval("D", new DoubleInterval(50.0, 200.0));
            HashMap<Integer, BigDecimal> synFactors = new HashMap<Integer, BigDecimal>();
            synFactors.put(2, BigDecimal.valueOf(1.6));
            synFactors.put(3, BigDecimal.valueOf(1.5));
            this.putSynergyFactors("A", new HashMap<Integer, BigDecimal>(synFactors));
            this.putSynergyFactors("B", new HashMap<Integer, BigDecimal>(synFactors));
            this.putSynergyFactors("C", new HashMap<Integer, BigDecimal>(synFactors));
            this.putSynergyFactors("D", new HashMap<Integer, BigDecimal>(synFactors));
        }

        @Override
        public MBVMBidderSetup build() {
            return new MBVMBidderSetup(this);
        }
    }
}

