/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import com.google.common.base.Preconditions;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class GSVMWorldSetup {
    private final IntegerInterval sizeInterval;

    private GSVMWorldSetup(GSVMWorldSetupBuilder builder) {
        this.sizeInterval = builder.sizeInterval;
    }

    Integer drawSize(UniformDistributionRNG rng) {
        return rng.nextInt(this.sizeInterval);
    }

    public static class GSVMWorldSetupBuilder {
        private static final int DEFAULT_SIZE = 6;
        private IntegerInterval sizeInterval = new IntegerInterval(6);

        public void setSizeInterval(IntegerInterval sizeInterval) {
            Preconditions.checkArgument((sizeInterval.getMinValue() > 0 ? 1 : 0) != 0);
            this.sizeInterval = sizeInterval;
        }

        public GSVMWorldSetup build() {
            return new GSVMWorldSetup(this);
        }
    }
}

