/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.lsvm;

import com.google.common.base.Preconditions;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.lsvm.LSVMGrid;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;

public class LSVMLicense
extends Good {
    private static final long serialVersionUID = 2814831251672586420L;
    private final int rowPosition;
    private final int columnPosition;
    private transient LSVMWorld world;

    protected LSVMLicense(long id, int row, int column, LSVMWorld world) {
        super(id, world.getId());
        this.rowPosition = row;
        this.columnPosition = column;
        this.world = world;
    }

    public int getRowPosition() {
        return this.rowPosition;
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LSVMLicense license = (LSVMLicense)o;
        if (this.rowPosition != license.rowPosition) {
            return false;
        }
        if (this.columnPosition != license.columnPosition) {
            return false;
        }
        return this.world.equals(license.world);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.world != null ? this.world.hashCode() : 0);
        return result;
    }

    @Override
    public LSVMWorld getWorld() {
        return this.world;
    }

    @Override
    public long getWorldId() {
        return this.worldId;
    }

    public void refreshFieldBackReferences(LSVMGrid grid) {
        Preconditions.checkArgument((grid.getWorld().getId() == this.worldId ? 1 : 0) != 0);
        this.world = grid.getWorld();
    }
}

