/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.Band;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class MRVMBand
extends Band
implements Serializable {
    private static final long serialVersionUID = -4482949789084377013L;
    private final long worldId;
    private final BigDecimal baseCapacity;
    private final int numberOfLots;
    private final List<MRVMLicense> licenses;
    private final Map<Integer, BigDecimal> synergies;
    private transient MRVMWorld world;

    public static HashSet<MRVMBand> createBands(MRVMWorld world, MRVMWorldSetup worldSetup, MRVMRegionsMap regionsMap, UniformDistributionRNG rng) {
        Set<MRVMWorldSetup.BandSetup> bandSetups = worldSetup.getBandSetups();
        HashSet<MRVMBand> bands = new HashSet<MRVMBand>();
        int currentLicenseId = 0;
        for (MRVMWorldSetup.BandSetup bandSetup : bandSetups) {
            MRVMBand band = new MRVMBand(bandSetup, world, currentLicenseId, rng);
            currentLicenseId += band.getNumberOfLicenses();
            bands.add(band);
        }
        return bands;
    }

    private MRVMBand(MRVMWorldSetup.BandSetup bandSetup, MRVMWorld world, int licenseStartId, UniformDistributionRNG rng) {
        super(bandSetup.getName());
        this.world = world;
        this.numberOfLots = bandSetup.drawNumberOfLots(rng);
        this.worldId = world.getId();
        this.baseCapacity = bandSetup.drawBaseCapacity(rng);
        this.synergies = ImmutableMap.copyOf(bandSetup.getSynergies());
        this.licenses = MRVMLicense.createLicenses(this, licenseStartId, world.getRegionsMap());
    }

    public BigDecimal getSynergy(int quantity) {
        if (quantity < 0 || quantity > this.numberOfLots) {
            throw new IllegalArgumentException("Immpossible quantity");
        }
        if (quantity <= 1) {
            return BigDecimal.ONE;
        }
        BigDecimal synergy = this.synergies.get(quantity);
        if (synergy == null) {
            return this.getSynergy(quantity - 1);
        }
        return synergy;
    }

    public BigDecimal calculateCAP(int quantity) {
        return MRVMWorld.capOfBand(this, quantity);
    }

    public BigDecimal getBaseCapacity() {
        return this.baseCapacity;
    }

    public MRVMWorld getWorld() {
        return this.world;
    }

    public Collection<MRVMLicense> getLicenses() {
        return Collections.unmodifiableCollection(this.licenses);
    }

    public int getNumberOfLots() {
        return this.numberOfLots;
    }

    @Override
    public int getNumberOfLicenses() {
        return this.licenses.size();
    }

    public long getWorldId() {
        return this.worldId;
    }

    private void setWorld(MRVMWorld world) {
        if (this.getWorldId() != world.getId()) {
            throw new IncompatibleWorldException("The stored worldId does not represent the passed world reference");
        }
        this.world = world;
    }

    public void refreshFieldBackReferences(MRVMWorld world) {
        this.setWorld(world);
        for (MRVMLicense license : this.licenses) {
            license.refreshFieldBackReferences(this);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseCapacity == null ? 0 : this.baseCapacity.hashCode());
        result = 31 * result + (this.licenses == null ? 0 : this.licenses.hashCode());
        result = 31 * result + this.numberOfLots;
        result = 31 * result + (this.synergies == null ? 0 : this.synergies.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MRVMBand other = (MRVMBand)obj;
        if (this.baseCapacity == null ? other.baseCapacity != null : !this.baseCapacity.equals(other.baseCapacity)) {
            return false;
        }
        if (this.licenses == null ? other.licenses != null : !this.licenses.equals(other.licenses)) {
            return false;
        }
        if (this.numberOfLots != other.numberOfLots) {
            return false;
        }
        return !(this.synergies == null ? other.synergies != null : !this.synergies.equals(other.synergies));
    }
}

