/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLocalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class MRVMLocalBidder
extends MRVMBidder {
    private static final long serialVersionUID = -7654713373213024311L;
    private transient Map<MRVMRegionsMap.Region, BigDecimal> gammaFactorCache = null;
    final Set<Integer> regionsOfInterest;

    MRVMLocalBidder(long id, long populationId, MRVMWorld world, MRVMLocalBidderSetup setup, UniformDistributionRNG rng) {
        super(id, populationId, world, setup, rng);
        Set<MRVMRegionsMap.Region> regionsOfInterest = setup.drawRegionsOfInterest(world, rng);
        HashSet<Integer> regionsOfInterestIds = new HashSet<Integer>();
        for (MRVMRegionsMap.Region region : regionsOfInterest) {
            if (!this.getWorld().getRegionsMap().getRegions().contains(region)) {
                throw new IllegalArgumentException("Region of Interest of this bidder is not part of the same world as this bidder");
            }
            regionsOfInterestIds.add(region.getId());
        }
        this.regionsOfInterest = Collections.unmodifiableSet(regionsOfInterestIds);
        this.store();
    }

    private static Map<MRVMRegionsMap.Region, BigDecimal> mapGammaFactors(MRVMWorld world, Set<Integer> regionsOfInterest) {
        HashMap<MRVMRegionsMap.Region, BigDecimal> result = new HashMap<MRVMRegionsMap.Region, BigDecimal>();
        for (MRVMRegionsMap.Region region : world.getRegionsMap().getRegions()) {
            BigDecimal gammaFactor = regionsOfInterest.contains(region.getId()) ? BigDecimal.ONE : BigDecimal.ZERO;
            result.put(region, gammaFactor);
        }
        return result;
    }

    @Override
    public BigDecimal gammaFactor(MRVMRegionsMap.Region r, Bundle<MRVMLicense> bundle) {
        return this.gammaFactors(bundle).get(r);
    }

    @Override
    public Map<MRVMRegionsMap.Region, BigDecimal> gammaFactors(Bundle<MRVMLicense> bundle) {
        if (this.gammaFactorCache == null) {
            this.gammaFactorCache = MRVMLocalBidder.mapGammaFactors(this.getWorld(), this.regionsOfInterest);
        }
        return Collections.unmodifiableMap(this.gammaFactorCache);
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> type, long seed) throws UnsupportedBiddingLanguageException {
        return super.getValueFunction(type, seed);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.regionsOfInterest == null ? 0 : this.regionsOfInterest.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MRVMLocalBidder other = (MRVMLocalBidder)obj;
        return !(this.regionsOfInterest == null ? other.regionsOfInterest != null : !this.regionsOfInterest.containsAll(other.regionsOfInterest) && this.regionsOfInterest.size() == other.regionsOfInterest.size());
    }
}

