/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.srvm.RandomOrderXORQFactory;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidderSetup;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.core.model.srvm.SizeOrderedGenericFactory;
import org.spectrumauctions.sats.core.model.srvm.SizeOrderedGenericPowersetFactory;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class SRVMBidder
extends Bidder<SRVMLicense>
implements GenericValueBidder<SRVMBand> {
    private static final int CALCSCALE = 5;
    private static final long serialVersionUID = -4577743658098455267L;
    private transient SRVMWorld world;
    private final BigDecimal bidderStrength;
    private final HashMap<String, Integer> synergyThreshold;
    private final HashMap<String, BigDecimal> baseValues;
    private final HashMap<String, BigDecimal> intrabandSynergyFactors;
    private final BigDecimal interbandSynergyValue;

    SRVMBidder(SRVMBidderSetup setup, SRVMWorld world, long currentId, long population, RNGSupplier rngSupplier) {
        super(setup, population, currentId, world.getId());
        this.world = world;
        HashMap<SRVMBand, Integer> synergyThreshold = setup.drawSynergyThresholds(world, rngSupplier);
        this.synergyThreshold = this.bandNameMap(synergyThreshold);
        this.bidderStrength = setup.drawBidderStrength(world, rngSupplier);
        HashMap<SRVMBand, BigDecimal> baseValues = setup.drawBaseValues(world, this.bidderStrength, rngSupplier);
        this.baseValues = this.bandNameMap(baseValues);
        HashMap<SRVMBand, BigDecimal> intrabandSynergyFactors = setup.drawIntraBandSynergyFactors(world, rngSupplier);
        this.intrabandSynergyFactors = this.bandNameMap(intrabandSynergyFactors);
        this.interbandSynergyValue = setup.drawInterBandSynergyFactor(world, rngSupplier);
        this.store();
    }

    private <T> HashMap<String, T> bandNameMap(Map<SRVMBand, T> inputMap) {
        Preconditions.checkArgument((this.world.getBands().containsAll(inputMap.keySet()) && this.world.getBands().size() == inputMap.size() ? 1 : 0) != 0, (Object)"Map is not complete for this world");
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry<SRVMBand, T> inputEntry : inputMap.entrySet()) {
            result.put(inputEntry.getKey().getName(), inputEntry.getValue());
        }
        return result;
    }

    @Override
    public SRVMWorld getWorld() {
        return this.world;
    }

    public BigDecimal getBidderStrength() {
        return this.bidderStrength;
    }

    public Map<String, Integer> getSynergyThreshold() {
        return Collections.unmodifiableMap(this.synergyThreshold);
    }

    public Map<String, BigDecimal> getBaseValues() {
        return Collections.unmodifiableMap(this.baseValues);
    }

    public Map<String, BigDecimal> getIntrabandSynergyFactors() {
        return Collections.unmodifiableMap(this.intrabandSynergyFactors);
    }

    public BigDecimal getInterbandSynergyValue() {
        return this.interbandSynergyValue;
    }

    @Override
    public BigDecimal calculateValue(Bundle<SRVMLicense> licenses) {
        HashMap<SRVMBand, Integer> bandCount = new HashMap<SRVMBand, Integer>();
        for (SRVMBand band : this.getWorld().getBands()) {
            bandCount.put(band, 0);
        }
        for (SRVMLicense license : licenses) {
            bandCount.put(license.getBand(), (Integer)bandCount.get(license.getBand()) + 1);
        }
        return this.calculateValue((Map<SRVMBand, Integer>)bandCount);
    }

    @Override
    public BigDecimal calculateValue(Map<SRVMBand, Integer> genericQuantities) {
        BigDecimal bandValuesSum = BigDecimal.ZERO;
        int synergyBandCount = 0;
        for (Map.Entry<SRVMBand, Integer> entry : genericQuantities.entrySet()) {
            if (entry.getValue() == 0) continue;
            bandValuesSum = bandValuesSum.add(this.getBandValue(entry.getKey(), entry.getValue()));
            ++synergyBandCount;
        }
        if (synergyBandCount >= 2) {
            bandValuesSum = bandValuesSum.multiply(this.interbandSynergyValue);
        }
        return bandValuesSum;
    }

    private BigDecimal getBandValue(SRVMBand band, int quantity) {
        double lnApproximation;
        BigDecimal ln;
        int firstSummand = quantity > this.synergyThreshold.get(band.getName()) ? this.synergyThreshold.get(band.getName()) : quantity;
        BigDecimal minFraction = new BigDecimal(firstSummand - 1).divide(new BigDecimal(firstSummand), 5, RoundingMode.CEILING);
        BigDecimal synergyFactor = this.intrabandSynergyFactors.get(band.getName());
        BigDecimal secondSummand = minFraction.multiply(synergyFactor);
        int toLog = quantity - (this.synergyThreshold.get(band.getName()) - 1);
        BigDecimal thirdSummand = toLog <= 0 ? BigDecimal.ZERO : ((ln = new BigDecimal(lnApproximation = Math.log(toLog), new MathContext(5, RoundingMode.CEILING))).compareTo(BigDecimal.ZERO) >= 0 ? ln : BigDecimal.ZERO);
        BigDecimal firstFactor = new BigDecimal(firstSummand).add(secondSummand).add(thirdSummand);
        BigDecimal baseValue = this.baseValues.get(band.getName());
        return firstFactor.multiply(baseValue);
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, long seed) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR<SRVMLicense>((Collection<SRVMLicense>)this.world.getLicenses(), new JavaUtilRNGSupplier(seed), this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR<SRVMLicense>((Collection<SRVMLicense>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR<SRVMLicense>((Collection<SRVMLicense>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(GenericSizeIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericSizeDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(XORQRandomOrderSimple.class)) {
            return (T)((BiddingLanguage)clazz.cast(RandomOrderXORQFactory.getXORQRandomOrderSimpleLang(this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public void refreshReference(World world) {
        Preconditions.checkArgument((world.getId() == this.getWorldId() ? 1 : 0) != 0);
        if (!(world instanceof SRVMWorld)) {
            throw new IllegalArgumentException("World is not of correct type");
        }
        this.world = (SRVMWorld)world;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.baseValues == null ? 0 : this.baseValues.hashCode());
        result = 31 * result + (this.bidderStrength == null ? 0 : this.bidderStrength.hashCode());
        result = 31 * result + (this.interbandSynergyValue == null ? 0 : this.interbandSynergyValue.hashCode());
        result = 31 * result + (this.intrabandSynergyFactors == null ? 0 : this.intrabandSynergyFactors.hashCode());
        result = 31 * result + (this.synergyThreshold == null ? 0 : this.synergyThreshold.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SRVMBidder other = (SRVMBidder)obj;
        if (this.baseValues == null ? other.baseValues != null : !this.baseValues.equals(other.baseValues)) {
            return false;
        }
        if (this.bidderStrength == null ? other.bidderStrength != null : !this.bidderStrength.equals(other.bidderStrength)) {
            return false;
        }
        if (this.interbandSynergyValue == null ? other.interbandSynergyValue != null : !this.interbandSynergyValue.equals(other.interbandSynergyValue)) {
            return false;
        }
        if (this.intrabandSynergyFactors == null ? other.intrabandSynergyFactors != null : !this.intrabandSynergyFactors.equals(other.intrabandSynergyFactors)) {
            return false;
        }
        return !(this.synergyThreshold == null ? other.synergyThreshold != null : !this.synergyThreshold.equals(other.synergyThreshold));
    }
}

