/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.model.BidderSetup;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class SRVMBidderSetup
extends BidderSetup {
    private final Map<String, IntegerInterval> synergyThresholds;
    private final Map<String, BigDecimal> meanBaseValues;
    private final Map<String, DoubleInterval> intraBandSynergyFactors;
    private final DoubleInterval interBandSynergyFactor;
    private final Map<String, DoubleInterval> randomInfluence;
    private final DoubleInterval bidderStrength;

    private SRVMBidderSetup(Builder builder) {
        super(builder);
        this.synergyThresholds = ImmutableMap.copyOf((Map)builder.synergyThresholds);
        this.meanBaseValues = ImmutableMap.copyOf((Map)builder.meanBaseValues);
        this.intraBandSynergyFactors = ImmutableMap.copyOf((Map)builder.intraBandSynergyFactors);
        this.interBandSynergyFactor = builder.interBandSynergyFactor;
        this.randomInfluence = ImmutableMap.copyOf((Map)builder.randomInfluence);
        this.bidderStrength = builder.bidderStrength;
    }

    public HashMap<SRVMBand, Integer> drawSynergyThresholds(SRVMWorld world, RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        HashMap<SRVMBand, Integer> result = new HashMap<SRVMBand, Integer>();
        for (SRVMBand band : world.getBands()) {
            IntegerInterval interval = this.synergyThresholds.get(band.getName());
            if (interval == null) {
                throw new IllegalArgumentException("No synergies defined for band " + band.getName());
            }
            if (!interval.isStrictlyPositive()) {
                throw new IllegalArgumentException("Synergy theshold must be strictly positive");
            }
            result.put(band, rng.nextInt(interval));
        }
        return result;
    }

    public HashMap<SRVMBand, BigDecimal> drawBaseValues(SRVMWorld world, BigDecimal bidderStrength, RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        HashMap<SRVMBand, BigDecimal> result = new HashMap<SRVMBand, BigDecimal>();
        for (SRVMBand band : world.getBands()) {
            BigDecimal meanBaseValue = this.meanBaseValues.get(band.getName());
            DoubleInterval randomInfluenceInterval = this.randomInfluence.get(band.getName());
            if (meanBaseValue == null) {
                throw new IllegalArgumentException("No mean base value defined for band " + band.getName());
            }
            if (randomInfluenceInterval == null || !randomInfluenceInterval.isStrictlyPositive()) {
                throw new IllegalArgumentException("Base Value must be defined and strictly positive");
            }
            BigDecimal randomInfluence = rng.nextBigDecimal(randomInfluenceInterval);
            BigDecimal baseValue = meanBaseValue.multiply(bidderStrength).multiply(randomInfluence);
            result.put(band, baseValue);
        }
        return result;
    }

    public HashMap<SRVMBand, BigDecimal> drawIntraBandSynergyFactors(SRVMWorld world, RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        HashMap<SRVMBand, BigDecimal> result = new HashMap<SRVMBand, BigDecimal>();
        for (SRVMBand band : world.getBands()) {
            DoubleInterval interval = this.intraBandSynergyFactors.get(band.getName());
            if (interval == null) {
                throw new IllegalArgumentException("No synergies defined for band " + band.getName());
            }
            if (interval.getMinValue() < 1.0) {
                throw new IllegalArgumentException("Synergy factor must be at least one");
            }
            result.put(band, rng.nextBigDecimal(interval));
        }
        return result;
    }

    public BigDecimal drawInterBandSynergyFactor(SRVMWorld world, RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        if (this.interBandSynergyFactor.getMinValue() < 1.0) {
            throw new IllegalArgumentException("Synergy factor must be at least one");
        }
        return rng.nextBigDecimal(this.interBandSynergyFactor);
    }

    public BigDecimal drawBidderStrength(SRVMWorld world, RNGSupplier rngSupplier) {
        return rngSupplier.getUniformDistributionRNG().nextBigDecimal(this.bidderStrength);
    }

    public static final class PrimaryBidderBuilder
    extends Builder {
        public PrimaryBidderBuilder() {
            super("Primary Bidder Setup", 2);
            this.putMeanBaseValue("A", new BigDecimal(300));
            this.putMeanBaseValue("B", new BigDecimal(70));
            this.putMeanBaseValue("C", new BigDecimal(15));
            this.putIntraBandSynergyFactor("A", new DoubleInterval(3.75, 4.25));
            this.putIntraBandSynergyFactor("B", new DoubleInterval(1.75, 2.25));
            this.putIntraBandSynergyFactor("C", new DoubleInterval(1.75, 2.25));
        }
    }

    public static final class SecondaryBidderBuilder
    extends Builder {
        public SecondaryBidderBuilder() {
            super("Secondary Bidder Setup", 2);
            this.putMeanBaseValue("A", new BigDecimal(200));
            this.putMeanBaseValue("B", new BigDecimal(70));
            this.putMeanBaseValue("C", new BigDecimal(15));
            this.putIntraBandSynergyFactor("A", new DoubleInterval(1.75, 2.25));
            this.putIntraBandSynergyFactor("B", new DoubleInterval(1.75, 2.25));
            this.putIntraBandSynergyFactor("C", new DoubleInterval(1.75, 2.25));
        }
    }

    public static final class HighFrequenceBidderBuilder
    extends Builder {
        public HighFrequenceBidderBuilder() {
            super("2.6 Ghz Bidder (High Frequence Bidder) Setup", 1);
            this.putMeanBaseValue("A", new BigDecimal(0));
            this.putMeanBaseValue("B", new BigDecimal(70));
            this.putMeanBaseValue("C", new BigDecimal(15));
            this.putIntraBandSynergyFactor("A", new DoubleInterval(1.75, 2.25));
            this.putIntraBandSynergyFactor("B", new DoubleInterval(1.75, 2.25));
            this.putIntraBandSynergyFactor("C", new DoubleInterval(1.75, 2.25));
        }
    }

    public static final class SmallBidderBuilder
    extends Builder {
        public SmallBidderBuilder() {
            super("Small Bidder Setup", 2);
            this.putMeanBaseValue("A", new BigDecimal(0));
            this.putMeanBaseValue("B", new BigDecimal(0));
            this.putMeanBaseValue("C", new BigDecimal(8));
            this.putIntraBandSynergyFactor("A", new DoubleInterval(1.75, 2.25));
            this.putIntraBandSynergyFactor("B", new DoubleInterval(1.75, 2.25));
            this.putIntraBandSynergyFactor("C", new DoubleInterval(1.75, 2.25));
        }
    }

    private static abstract class Builder
    extends BidderSetup.Builder {
        private final Map<String, IntegerInterval> synergyThresholds = new HashMap<String, IntegerInterval>();
        private final Map<String, BigDecimal> meanBaseValues = new HashMap<String, BigDecimal>();
        private final Map<String, DoubleInterval> intraBandSynergyFactors = new HashMap<String, DoubleInterval>();
        private DoubleInterval interBandSynergyFactor;
        private final Map<String, DoubleInterval> randomInfluence = new HashMap<String, DoubleInterval>();
        private DoubleInterval bidderStrength;

        Builder(String setupName, int numberOfBidders) {
            super(setupName, numberOfBidders);
            this.putRandomInfluence("A", new DoubleInterval(0.75, 1.25));
            this.putRandomInfluence("B", new DoubleInterval(0.75, 1.25));
            this.putRandomInfluence("C", new DoubleInterval(0.75, 1.25));
            this.putSynergyThreshold("A", new IntegerInterval(4));
            this.putSynergyThreshold("B", new IntegerInterval(2));
            this.putSynergyThreshold("C", new IntegerInterval(2));
            this.bidderStrength = new DoubleInterval(0.75, 1.25);
            this.setInterBandSynergyFactor(new DoubleInterval(1.0, 1.2));
        }

        public void putRandomInfluence(String bandName, DoubleInterval randomInfluenceInterval) {
            Preconditions.checkArgument((boolean)randomInfluenceInterval.isStrictlyPositive());
            this.randomInfluence.put(bandName, randomInfluenceInterval);
        }

        public DoubleInterval removeRandomInflucence(String bandName) {
            return this.randomInfluence.remove(bandName);
        }

        public Map<String, DoubleInterval> getRandomInfluence() {
            return Collections.unmodifiableMap(this.randomInfluence);
        }

        @Override
        public SRVMBidderSetup build() {
            return new SRVMBidderSetup(this);
        }

        public DoubleInterval getBidderStrength() {
            return this.bidderStrength;
        }

        public void setBidderStrength(DoubleInterval bidderStrength) {
            this.bidderStrength = bidderStrength;
        }

        public Map<String, IntegerInterval> getSynergyThresholds() {
            return Collections.unmodifiableMap(this.synergyThresholds);
        }

        public Map<String, BigDecimal> getMeanBaseValues() {
            return Collections.unmodifiableMap(this.meanBaseValues);
        }

        public Map<String, DoubleInterval> getIntraBandSynergyFactors() {
            return Collections.unmodifiableMap(this.intraBandSynergyFactors);
        }

        public DoubleInterval getInterBandSynergyFactor() {
            return this.interBandSynergyFactor;
        }

        public void setInterBandSynergyFactor(DoubleInterval interBandSynergyFactor) {
            this.interBandSynergyFactor = interBandSynergyFactor;
        }

        public void putSynergyThreshold(String bandName, IntegerInterval thresholdInterval) {
            this.synergyThresholds.put(bandName, thresholdInterval);
        }

        public IntegerInterval removeSynergyThreshold(String bandName) {
            return this.synergyThresholds.remove(bandName);
        }

        public void putMeanBaseValue(String bandName, BigDecimal meanBaseValue) {
            this.meanBaseValues.put(bandName, meanBaseValue);
        }

        public BigDecimal removeBaseValue(String bandName) {
            return this.meanBaseValues.remove(bandName);
        }

        public void putIntraBandSynergyFactor(String bandName, DoubleInterval synergyFactor) {
            this.intraBandSynergyFactors.put(bandName, synergyFactor);
        }

        public DoubleInterval removeIntraBandSynergyFactor(String bandName) {
            return this.intraBandSynergyFactors.remove(bandName);
        }
    }
}

