/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class BigDecimalUtils {
    public static boolean equalIgnoreScale(Collection<BigDecimal> collection1, Collection<BigDecimal> collection2) {
        if (collection1 == null || collection2 == null) {
            return false;
        }
        if (collection1.size() != collection2.size()) {
            return false;
        }
        ArrayList<BigDecimal> sorted1 = new ArrayList<BigDecimal>(collection1);
        ArrayList<BigDecimal> sorted2 = new ArrayList<BigDecimal>(collection2);
        Collections.sort(sorted1);
        Collections.sort(sorted2);
        Iterator iter1 = sorted1.iterator();
        Iterator iter2 = sorted2.iterator();
        while (iter1.hasNext()) {
            if (((BigDecimal)iter1.next()).compareTo((BigDecimal)iter2.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equalIgnoreScaleOnValues(Map<T, BigDecimal> map1, Map<T, BigDecimal> map2) {
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        Iterator<Map.Entry<T, BigDecimal>> iter1 = map1.entrySet().iterator();
        Iterator<Map.Entry<T, BigDecimal>> iter2 = map1.entrySet().iterator();
        while (iter1.hasNext()) {
            Map.Entry<T, BigDecimal> entry1 = iter1.next();
            Map.Entry<T, BigDecimal> entry2 = iter2.next();
            if (!entry1.getKey().equals(entry2.getKey())) {
                return false;
            }
            if (entry1.getValue() == null && entry2.getValue() != null || entry1.getValue() != null && entry2.getValue() == null) {
                return false;
            }
            if (entry1.getValue().compareTo(entry2.getValue()) == 0) continue;
            return false;
        }
        return true;
    }

    public static int hashCodeIgnoringScale(Map<?, BigDecimal> map) {
        int keyCode = Objects.hashCode((Object[])map.keySet().toArray());
        int valCode = BigDecimalUtils.hashCodeIgnoringScale(map.values());
        return keyCode + valCode;
    }

    public static int hashCodeIgnoringScale(Collection<BigDecimal> collection) {
        int prime = 31;
        int result = 31;
        for (BigDecimal bd : collection) {
            result = 31 * result + (bd == null ? 0 : new Double(bd.doubleValue()).hashCode());
        }
        return result;
    }
}

