/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.math;

import java.math.BigDecimal;
import org.spectrumauctions.sats.core.util.math.LinearFunction;

public class NotDifferentiableException
extends Exception {
    private static final long serialVersionUID = -3769389560505390908L;
    private final LinearFunction lowerAdjacentFunction;
    private final LinearFunction higherAdjacentFunction;
    private final BigDecimal x;

    NotDifferentiableException(LinearFunction lowerAdjacentFunction, LinearFunction higherAdjacentFunction, BigDecimal x) {
        if (lowerAdjacentFunction == null && higherAdjacentFunction == null) {
            throw new IllegalArgumentException("At least one adjacent function must be defined");
        }
        this.lowerAdjacentFunction = lowerAdjacentFunction;
        this.higherAdjacentFunction = higherAdjacentFunction;
        this.x = x;
    }

    public LinearFunction getLowerAdjacentFunction() {
        return this.lowerAdjacentFunction;
    }

    public LinearFunction getHigherAdjacentFunction() {
        return this.higherAdjacentFunction;
    }

    public BigDecimal getX() {
        return this.x;
    }

    public BigDecimal getCornerPointY() {
        if (this.lowerAdjacentFunction != null) {
            return this.lowerAdjacentFunction.getY(this.x);
        }
        return this.higherAdjacentFunction.getY(this.x);
    }
}

