/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.imip;

import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.MIP;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spectrumauctions.sats.core.util.math.ContinuousPiecewiseLinearFunction;
import org.spectrumauctions.sats.core.util.math.LinearFunction;
import org.spectrumauctions.sats.core.util.math.NotDifferentiableException;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.opt.imip.PartialMIP;

public final class PiecewiseLinearPartialMIP
extends PartialMIP {
    private final String linearPieceVariableName = "_Z";
    private final String conditionalXVariableName = "_condX";
    private List<Variable> linearPieceVariable;
    private List<Variable> conditionalXVariable;
    private ContinuousPiecewiseLinearFunction func;
    private Variable functionInput;
    private Variable functionOutput;
    private String auxiliaryPartialName;
    private DoubleInterval inputRange;

    public PiecewiseLinearPartialMIP(ContinuousPiecewiseLinearFunction func, Variable functionInput, Variable functionOutput, String auxiliaryPartialName) {
        this.func = func;
        this.functionInput = functionInput;
        this.functionOutput = functionOutput;
        this.auxiliaryPartialName = auxiliaryPartialName;
        this.initAuxiliaryVariables();
    }

    private Variable getZVar(int piecenumber) {
        return this.linearPieceVariable.get(piecenumber - 1);
    }

    private Variable getConditionalXVar(int piecenumber) {
        return this.conditionalXVariable.get(piecenumber - 1);
    }

    private void initAuxiliaryVariables() {
        this.linearPieceVariable = new ArrayList<Variable>();
        this.conditionalXVariable = new ArrayList<Variable>();
        List cornerPoints = this.func.getCornerPoints();
        for (int i = 1; i < cornerPoints.size(); ++i) {
            String varName = this.auxiliaryPartialName.concat("_Z").concat(String.valueOf(i));
            this.linearPieceVariable.add(new Variable(varName, VarType.BOOLEAN, 0.0, 1.0));
            varName = this.auxiliaryPartialName.concat("_condX").concat(String.valueOf(i));
            this.conditionalXVariable.add(new Variable(varName, VarType.DOUBLE, this.functionInput.getLowerBound(), this.functionInput.getUpperBound()));
        }
    }

    public Set<Constraint> constrainAuxiliaryVariables() {
        HashSet<Constraint> result = new HashSet<Constraint>();
        List cornerPoints = this.func.getCornerPoints();
        for (int i = 1; i < cornerPoints.size(); ++i) {
            AbstractMap.SimpleImmutableEntry lowerCornerPoint = (AbstractMap.SimpleImmutableEntry)cornerPoints.get(i - 1);
            AbstractMap.SimpleImmutableEntry higherCornerPoint = (AbstractMap.SimpleImmutableEntry)cornerPoints.get(i);
            Constraint lowerC = new Constraint(CompareType.LEQ, 0.0);
            lowerC.addTerm(((BigDecimal)lowerCornerPoint.getKey()).doubleValue(), this.getZVar(i));
            lowerC.addTerm(-1.0, this.getConditionalXVar(i));
            result.add(lowerC);
            Constraint upperC = new Constraint(CompareType.LEQ, 0.0);
            upperC.addTerm(((BigDecimal)higherCornerPoint.getKey()).doubleValue() * -1.0, this.getZVar(i));
            upperC.addTerm(1.0, this.getConditionalXVar(i));
            result.add(upperC);
        }
        Constraint zCount = new Constraint(CompareType.EQ, 1.0);
        for (int i = 1; i < cornerPoints.size(); ++i) {
            zCount.addTerm(1.0, this.getZVar(i));
        }
        result.add(zCount);
        Constraint condXSum = new Constraint(CompareType.EQ, 0.0);
        condXSum.addTerm(-1.0, this.functionInput);
        for (int i = 1; i < cornerPoints.size(); ++i) {
            condXSum.addTerm(1.0, this.getConditionalXVar(i));
        }
        result.add(condXSum);
        return result;
    }

    public Constraint constrainFunctionOutputVariable() {
        Constraint c = new Constraint(CompareType.EQ, 0.0);
        c.addTerm(-1.0, this.functionOutput);
        List cornerPoints = this.func.getCornerPoints();
        for (int i = 1; i < cornerPoints.size(); ++i) {
            LinearFunction inbetweenFunction;
            BigDecimal lowerX = (BigDecimal)((AbstractMap.SimpleImmutableEntry)cornerPoints.get(i - 1)).getKey();
            BigDecimal higherX = (BigDecimal)((AbstractMap.SimpleImmutableEntry)cornerPoints.get(i)).getKey();
            try {
                inbetweenFunction = this.func.functionAt(higherX);
                throw new RuntimeException("point is a corner point. A NotDifferentiableException should be thrown");
            }
            catch (NotDifferentiableException e) {
                inbetweenFunction = e.getLowerAdjacentFunction();
                double yOfLowerX = this.func.getY(lowerX).doubleValue();
                double slope = inbetweenFunction.getSlope().doubleValue();
                c.addTerm(yOfLowerX, this.getZVar(i));
                c.addTerm(slope, this.getConditionalXVar(i));
                c.addTerm(-1.0 * slope * lowerX.doubleValue(), this.getZVar(i));
                continue;
            }
        }
        return c;
    }

    @Override
    public void appendVariablesToMip(MIP mip) {
        for (Variable var : this.getVariables()) {
            mip.add(var);
        }
    }

    @Override
    public Set<Variable> getVariables() {
        HashSet<Variable> vars = new HashSet<Variable>();
        vars.addAll(super.getVariables());
        vars.addAll(this.linearPieceVariable);
        vars.addAll(this.conditionalXVariable);
        return vars;
    }

    @Override
    public void appendConstraintsToMip(MIP mip) {
        super.appendConstraintsToMip(mip);
        for (Constraint constraint : this.constrainAuxiliaryVariables()) {
            mip.add(constraint);
        }
        mip.add(this.constrainFunctionOutputVariable());
    }
}

