/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.opt.model.Allocation;

public class GenericAllocation<T extends GenericDefinition>
implements Allocation<GenericValue<T>> {
    protected final ImmutableMap<Bidder<?>, GenericValue<T>> values;

    protected GenericAllocation(Builder<T> builder) {
        this.values = ImmutableMap.copyOf((Map)((Builder)builder).storedValues);
    }

    @Override
    public GenericValue<T> getAllocation(Bidder<?> bidder) {
        return (GenericValue)this.values.get(bidder);
    }

    @Override
    public Collection<Bidder<?>> getBidders() {
        return this.values.keySet();
    }

    @Override
    public BigDecimal getTotalValue() {
        BigDecimal sum = BigDecimal.ZERO;
        for (GenericValue genVal : this.values.values()) {
            sum.add(genVal.getValue());
        }
        return sum;
    }

    public static class Builder<T extends GenericDefinition> {
        private Map<Bidder<?>, GenericValue<T>> storedValues = new HashMap();

        public void putGenericValue(Bidder<?> bidder, GenericValue<T> value) {
            Preconditions.checkNotNull(bidder);
            Preconditions.checkNotNull(value);
            this.storedValues.put(bidder, value);
        }
    }
}

