/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm;

import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.MIP;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMBidderPartialMIP;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMWorldPartialMip;

public class MRVMRegionalBidderPartialMip
extends MRVMBidderPartialMIP {
    private final MRVMRegionalBidder bidder;

    public MRVMRegionalBidderPartialMip(MRVMRegionalBidder bidder, double scalingFactor, MRVMWorldPartialMip worldMip) {
        super((MRVMBidder)bidder, scalingFactor, worldMip);
        this.bidder = bidder;
    }

    public Constraint constrainValue() {
        Constraint constraint = new Constraint(CompareType.EQ, 0.0);
        Variable biddersValue = this.worldPartialMip.getValueVariable((MRVMBidder)this.bidder);
        constraint.addTerm(-1.0, biddersValue);
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            BigDecimal gammaFactor = this.bidder.gammaFactor(region, null);
            double constant = gammaFactor.doubleValue();
            Variable regionalOmega = this.getOmegaVariable(region);
            constraint.addTerm(constant, regionalOmega);
        }
        return constraint;
    }

    @Override
    public void appendToMip(MIP mip) {
        super.appendToMip(mip);
        mip.add(this.constrainValue());
    }
}

