/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.vcg.external.domain;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.opt.vcg.external.domain.BidderPayment;

public final class Payment<T extends Good> {
    private final Map<Bidder<T>, BidderPayment> payments;

    public Payment(Map<Bidder<T>, BidderPayment> payments) {
        this.payments = Collections.unmodifiableMap(payments);
    }

    public double getTotalPayments() {
        double totalPayments = 0.0;
        for (BidderPayment payment : this.getPayments()) {
            totalPayments += payment.getAmount();
        }
        return totalPayments;
    }

    public Collection<BidderPayment> getPayments() {
        return this.payments.values();
    }

    public Map<Bidder<T>, BidderPayment> getPaymentMap() {
        return this.payments;
    }

    public BidderPayment paymentOf(Bidder<T> bidder) {
        BidderPayment payment = this.payments.get(bidder);
        if (payment == null) {
            return new BidderPayment(0.0);
        }
        return payment;
    }

    public String toString() {
        return "Payment[payments=" + this.payments + "]";
    }

    public Set<Bidder<T>> getWinners() {
        return this.payments.keySet();
    }

    public boolean isWinner(Bidder<T> bidder) {
        return this.payments.containsKey(bidder);
    }

    public static <T extends Good> Payment<T> getZeroPayment(Set<Bidder<T>> bidders) {
        BidderPayment zeroBidderPayment = new BidderPayment(0.0);
        Function zeroPaymentFunction = Functions.constant((Object)zeroBidderPayment);
        Map emptyPaymentMap = Maps.asMap(bidders, (Function)zeroPaymentFunction);
        return new Payment<T>(emptyPaymentMap);
    }
}

