/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.vcg.external.vcg;

import java.util.HashMap;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.opt.vcg.external.domain.Auction;
import org.spectrumauctions.sats.opt.vcg.external.domain.AuctionResult;
import org.spectrumauctions.sats.opt.vcg.external.domain.BidderAllocation;
import org.spectrumauctions.sats.opt.vcg.external.domain.BidderPayment;
import org.spectrumauctions.sats.opt.vcg.external.domain.Payment;
import org.spectrumauctions.sats.opt.vcg.external.vcg.XORVCGAuction;

public class ReservePriceVCGAuction<T extends Good>
extends XORVCGAuction<T> {
    private double goodReservePrice;

    public ReservePriceVCGAuction(Auction<T> auction, double goodReservePrice) {
        super(auction);
        this.goodReservePrice = goodReservePrice;
    }

    @Override
    protected AuctionResult<T> calculateVCGPrices(Auction<T> auction) {
        Auction<T> adaptedAuction = auction.withLowBidsRemoved(this.goodReservePrice);
        AuctionResult<T> result = super.calculateVCGPrices(adaptedAuction);
        HashMap newPaymentMap = new HashMap(result.getAllocation().getWinners().size());
        for (Bidder<T> winner : result.getAllocation().getWinners()) {
            double vcgPayment = result.getPayment().paymentOf(winner).getAmount();
            double reservePrice = (double)((BidderAllocation)result.getAllocation().getAllocation((Bidder)winner)).getGoods().size() * this.goodReservePrice;
            double newPrice = Math.max(vcgPayment, reservePrice);
            newPaymentMap.put(winner, new BidderPayment(newPrice));
        }
        Payment newPayment = new Payment(newPaymentMap);
        return new AuctionResult(newPayment, result.getAllocation());
    }
}

