/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.vcg.external.winnerdetermination;

import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.MIP;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.opt.vcg.external.domain.Auction;
import org.spectrumauctions.sats.opt.vcg.external.winnerdetermination.WinnerDetermination;

public class XORWinnerDetermination<T extends Good>
extends WinnerDetermination<T> {
    private Map<XORValue<T>, Variable> bidVariables = new HashMap<XORValue<T>, Variable>();
    private IMIP winnerDeterminationProgram;

    public XORWinnerDetermination(Auction<T> auction) {
        super(auction);
        this.winnerDeterminationProgram = this.createWinnerDeterminationMIP(auction);
    }

    private IMIP createWinnerDeterminationMIP(Auction<T> auction) {
        MIP winnerDeterminationProgram = new MIP();
        winnerDeterminationProgram.setObjectiveMax(true);
        for (Bidder<T> bidder : auction.getBidders()) {
            for (XORValue bundleBid : auction.getBid(bidder).getValues()) {
                Variable bidI = new Variable("Bid " + bundleBid.getId(), VarType.BOOLEAN, 0.0, 1.0);
                winnerDeterminationProgram.add(bidI);
                winnerDeterminationProgram.addObjectiveTerm(bundleBid.value().doubleValue(), bidI);
                this.bidVariables.put(bundleBid, bidI);
            }
        }
        HashMap<Good, Constraint> goods = new HashMap<Good, Constraint>();
        for (Bidder<T> bidder : auction.getBidders()) {
            Constraint exclusiveBids = new Constraint(CompareType.LEQ, 1.0);
            for (XORValue bundleBid : auction.getBid(bidder).getValues()) {
                exclusiveBids.addTerm(1.0, this.bidVariables.get(bundleBid));
                for (Good good : bundleBid.getLicenses()) {
                    Constraint noDoubleAssignment = (Constraint)goods.get(good);
                    if (noDoubleAssignment == null) {
                        noDoubleAssignment = new Constraint(CompareType.LEQ, 1.0);
                        goods.put(good, noDoubleAssignment);
                    }
                    noDoubleAssignment.addTerm(1.0, this.bidVariables.get(bundleBid));
                }
            }
            winnerDeterminationProgram.add(exclusiveBids);
        }
        for (Constraint noDoubleAssignments : goods.values()) {
            winnerDeterminationProgram.add(noDoubleAssignments);
        }
        return winnerDeterminationProgram;
    }

    @Override
    protected IMIP getMIP() {
        return this.winnerDeterminationProgram;
    }

    @Override
    protected Variable getBidVariable(XORValue<T> bundleBid) {
        return this.bidVariables.get(bundleBid);
    }
}

