/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.gsvm;

import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.opt.model.EfficientAllocator;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.vcg.external.vcg.ItemAllocation;

public class GSVMStandardMIP
extends ModelMIP
implements EfficientAllocator<ItemAllocation<GSVMLicense>> {
    private int n;
    private int m;
    private Variable[][][] G;
    private double[][] value;
    private int[] tauHat;
    private List<GSVMBidder> population;
    private Map<Long, GSVMLicense> licenseMap;
    private GSVMWorld world;
    private boolean allowAssigningLicensesWithZeroBasevalue;

    public GSVMStandardMIP(GSVMWorld world, List<GSVMBidder> population) {
        this(world, population, true);
    }

    public GSVMStandardMIP(GSVMWorld world, List<GSVMBidder> population, boolean allowAssigningLicensesWithZeroBasevalue) {
        this.m = world.getLicenses().size();
        this.licenseMap = new HashMap<Long, GSVMLicense>(this.m);
        world.getLicenses().stream().forEach(license -> this.licenseMap.put(license.getId(), (GSVMLicense)license));
        this.allowAssigningLicensesWithZeroBasevalue = allowAssigningLicensesWithZeroBasevalue;
        this.n = population.size();
        this.population = population;
        this.world = world;
        this.tauHat = new int[this.n];
        this.value = new double[this.n][this.m];
        this.getMip().setObjectiveMax(true);
        this.initValues();
        this.initVariables();
    }

    @Override
    public ItemAllocation<GSVMLicense> calculateAllocation() {
        SolverClient solver = new SolverClient();
        IMIPResult result = solver.solve((IMIP)this.getMip());
        HashMap allocation = new HashMap();
        for (int i = 0; i < this.n; ++i) {
            GSVMBidder bidder = this.population.get(i);
            Bundle bundle = new Bundle();
            for (int j = 0; j < this.m; ++j) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.value[i][j] > 0.0)) continue;
                for (int tau = 0; tau < this.tauHat[i]; ++tau) {
                    if (result.getValue(this.G[i][j][tau]) != 1.0) continue;
                    bundle.add((Good)this.licenseMap.get(j));
                }
            }
            allocation.put(bidder, bundle);
        }
        ItemAllocation.ItemAllocationBuilder builder = new ItemAllocation.ItemAllocationBuilder().withWorld((World)this.world).withTotalValue(BigDecimal.valueOf(result.getObjectiveValue())).withAllocation(allocation);
        return builder.build();
    }

    public void build() {
        int tau;
        int j;
        for (int i = 0; i < this.n; ++i) {
            for (int j2 = 0; j2 < this.m; ++j2) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.value[i][j2] > 0.0)) continue;
                for (int tau2 = 0; tau2 < this.tauHat[i]; ++tau2) {
                    this.getMip().addObjectiveTerm(this.calculateComplementarityMarkup(tau2 + 1) * this.value[i][j2], this.G[i][j2][tau2]);
                }
            }
        }
        for (j = 0; j < this.m; ++j) {
            Constraint constraint = new Constraint(CompareType.LEQ, 1.0, "SupplyConstraint j=" + j);
            for (int i = 0; i < this.n; ++i) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.value[i][j] > 0.0)) continue;
                for (tau = 0; tau < this.tauHat[i]; ++tau) {
                    constraint.addTerm(1.0, this.G[i][j][tau]);
                }
            }
            this.getMip().add(constraint);
        }
        for (j = 0; j < this.m; ++j) {
            for (int i = 0; i < this.n; ++i) {
                Constraint constraint = new Constraint(CompareType.GEQ, 0.0);
                for (int k = 0; k < this.m; ++k) {
                    if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.value[i][k] > 0.0)) continue;
                    for (int tau3 = 0; tau3 < this.tauHat[i]; ++tau3) {
                        constraint.addTerm(1.0, this.G[i][k][tau3]);
                    }
                }
                for (tau = 0; tau < this.tauHat[i]; ++tau) {
                    if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.value[i][j] > 0.0)) continue;
                    constraint.addTerm((double)(-(tau + 1)), this.G[i][j][tau]);
                }
                this.getMip().add(constraint);
            }
        }
    }

    private void initValues() {
        for (int i = 0; i < this.n; ++i) {
            int tauCounter = 0;
            for (int j = 0; j < this.m; ++j) {
                this.value[i][j] = this.getValue(i, j).orElse(0.0);
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.value[i][j] > 0.0)) continue;
                ++tauCounter;
            }
            this.tauHat[i] = tauCounter;
        }
    }

    private OptionalDouble getValue(int i, int j) {
        return this.population.stream().filter(bidder -> bidder.getId() == (long)i).mapToDouble(bidder -> {
            BigDecimal val = (BigDecimal)bidder.getBaseValues().get(j);
            return val == null ? 0.0 : val.doubleValue();
        }).reduce((element, otherElement) -> {
            throw new IllegalStateException("Error: Multiple values for agent: " + i + " and license: " + j + " in population");
        });
    }

    private void initVariables() {
        this.G = new Variable[this.n][][];
        for (int i = 0; i < this.n; ++i) {
            this.G[i] = new Variable[this.m][];
            for (int j = 0; j < this.m; ++j) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.value[i][j] > 0.0)) continue;
                this.G[i][j] = new Variable[this.tauHat[i]];
                for (int tau = 0; tau < this.tauHat[i]; ++tau) {
                    this.G[i][j][tau] = new Variable("g_i[" + i + "]j[" + j + "]t[" + tau + "]", VarType.BOOLEAN, 0.0, 1.0);
                    this.getMip().add(this.G[i][j][tau]);
                }
            }
        }
    }

    private double calculateComplementarityMarkup(int tau) {
        if (tau < 1) {
            throw new IllegalArgumentException("Error: tau has to be >=1");
        }
        return 1.0 + (double)(tau - 1) * 0.2;
    }
}

